/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.network.bidirectional;

import com.arkifgames.hoverboardmod.client.gui.inventory.GuiHoverboard;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardOptions;
import com.arkifgames.hoverboardmod.network.AbstractMessage;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDataSync
extends AbstractMessage<PacketDataSync> {
    private int playerId;
    private int entityId;
    private int options;
    private byte add;

    public PacketDataSync() {
    }

    public PacketDataSync(int entityId, HoverboardOptions options, byte add) {
        this.playerId = -1;
        this.entityId = entityId;
        this.options = options.value;
        this.add = add;
    }

    public PacketDataSync(int playerId, int entityId, HoverboardOptions options, byte add) {
        this.playerId = playerId;
        this.entityId = entityId;
        this.options = options.value;
        this.add = add;
    }

    public PacketDataSync(int playerId, int entityID, HoverboardOptions options, boolean checked) {
        this.playerId = playerId;
        this.entityId = entityID;
        this.options = options.value;
        this.add = (byte)(checked ? 1 : 0);
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.playerId = buffer.readInt();
        this.entityId = buffer.readInt();
        this.options = buffer.readInt();
        this.add = buffer.readByte();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.playerId);
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.options);
        buffer.writeByte((int)this.add);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            if (player.field_70170_p.func_73045_a(this.entityId) instanceof EntityHoverboard && Minecraft.func_71410_x().field_71462_r instanceof GuiHoverboard) {
                GuiHoverboard guiHoverboard = (GuiHoverboard)Minecraft.func_71410_x().field_71462_r;
                guiHoverboard.setChecked(this.options, this.add);
            }
        } else if (player.field_70170_p.func_73045_a(this.entityId) instanceof EntityHoverboard) {
            EntityHoverboard hoverboard = (EntityHoverboard)player.field_70170_p.func_73045_a(this.entityId);
            if (this.options == HoverboardOptions.privateStorage.value || this.options == HoverboardOptions.privatePilot.value || this.options == HoverboardOptions.privateDock.value) {
                if (player.field_70170_p.func_73045_a(this.playerId) instanceof EntityPlayer) {
                    EntityPlayer player1 = (EntityPlayer)player.field_70170_p.func_73045_a(this.playerId);
                    if (hoverboard.getOwnerUUID() != null && hoverboard.getOwnerUUID().equals(player1.func_110124_au())) {
                        if (this.add == 1) {
                            hoverboard.setOptions(hoverboard.getOptions() | this.options);
                        } else {
                            hoverboard.setOptions(hoverboard.getOptions() & ~this.options);
                        }
                    }
                }
            } else if (this.add == 1) {
                hoverboard.setOptions(hoverboard.getOptions() | this.options);
            } else {
                hoverboard.setOptions(hoverboard.getOptions() & ~this.options);
            }
            PacketDispatcher.sendToAll(this);
        }
    }
}

