/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.network.bidirectional;

import com.arkifgames.hoverboardmod.client.audio.SoundEvents;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.hoverboard.HoverboardUpgrades;
import com.arkifgames.hoverboardmod.network.AbstractMessage;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class PacketKeyRocketPress
extends AbstractMessage<PacketKeyRocketPress> {
    private int entityId;
    private int timerReload;
    private int timerShoot;
    private boolean canPressRocketKey;

    public PacketKeyRocketPress() {
    }

    public PacketKeyRocketPress(int entityId, boolean canPressRocketKey, int timerReload, int timerShoot) {
        this.entityId = entityId;
        this.canPressRocketKey = canPressRocketKey;
        this.timerReload = timerReload;
        this.timerShoot = timerShoot;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.entityId = buffer.readInt();
        this.canPressRocketKey = buffer.readBoolean();
        this.timerReload = buffer.readInt();
        this.timerShoot = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.canPressRocketKey);
        buffer.writeInt(this.timerReload);
        buffer.writeInt(this.timerShoot);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        EntityHoverboard hoverboard;
        if (player.field_70170_p.func_73045_a(this.entityId) != null && player.field_70170_p.func_73045_a(this.entityId) instanceof EntityHoverboard && (hoverboard = (EntityHoverboard)player.field_70170_p.func_73045_a(this.entityId)).hasUpgrade(HoverboardUpgrades.rocket)) {
            hoverboard.setCanPressRocketKey(this.canPressRocketKey);
            hoverboard.setTimerReload(this.timerReload);
            hoverboard.setTimerShoot(this.timerShoot);
            if (side.isServer()) {
                if (!this.canPressRocketKey) {
                    hoverboard.field_70170_p.func_184133_a(null, new BlockPos(hoverboard.field_70165_t, hoverboard.field_70163_u, hoverboard.field_70161_v), SoundEvents.HOVERBOARD_ENGAGE, SoundCategory.NEUTRAL, 0.75f, 1.0f);
                }
                PacketDispatcher.sendTo(this, (EntityPlayerMP)hoverboard.getPlayerRiding());
            }
        }
    }
}

