/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.network.bidirectional;

import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.network.AbstractMessage;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketParticle
extends AbstractMessage<PacketParticle> {
    private int entityId;
    private byte id;
    private boolean even;

    public PacketParticle() {
    }

    public PacketParticle(int entityID, byte id, boolean even) {
        this.entityId = entityID;
        this.id = id;
        this.even = even;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.entityId = buffer.readInt();
        this.id = buffer.readByte();
        this.even = buffer.readBoolean();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.entityId);
        buffer.writeByte((int)this.id);
        buffer.writeBoolean(this.even);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (side.isClient()) {
            if (player.field_70170_p.func_73045_a(this.entityId) instanceof EntityHoverboard) {
                EntityHoverboard hoverboard = (EntityHoverboard)player.field_70170_p.func_73045_a(this.entityId);
                switch (this.id) {
                    case 0: {
                        hoverboard.spawnThrusterParticles();
                        break;
                    }
                    case 1: {
                        float f = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.func_82716_a((Random)hoverboard.func_70681_au(), (double)(hoverboard.field_70165_t - (double)f), (double)(hoverboard.field_70165_t + (double)f));
                        double d1 = MathHelper.func_82716_a((Random)hoverboard.func_70681_au(), (double)(hoverboard.field_70163_u - (double)f1), (double)(hoverboard.field_70163_u + (double)f1));
                        double d2 = MathHelper.func_82716_a((Random)hoverboard.func_70681_au(), (double)(hoverboard.field_70161_v - (double)f), (double)(hoverboard.field_70161_v + (double)f));
                        hoverboard.spawnMissileParticles((this.even ? 1 : 0) + 1, d0, d1, d2);
                        break;
                    }
                    case 2: {
                        hoverboard.createParticleBall(0.35f, 2, false, false, (Entity)hoverboard);
                        break;
                    }
                }
            }
        } else {
            PacketDispatcher.sendToAllAround(this, player, 64.0);
        }
    }
}

