/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.network.client;

import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.network.AbstractMessage;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;

public class PacketShieldSync
extends AbstractMessage.AbstractClientMessage<PacketShieldSync> {
    private int entityID;
    private int entityProjectileID;

    public PacketShieldSync() {
    }

    public PacketShieldSync(int entityID, int entityProjectileID) {
        this.entityID = entityID;
        this.entityProjectileID = entityProjectileID;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.entityID = buffer.readInt();
        this.entityProjectileID = buffer.readInt();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.entityProjectileID);
    }

    @Override
    protected void process(EntityPlayer player, Side side) {
        if (player.func_130014_f_().func_73045_a(this.entityID) instanceof EntityHoverboard) {
            EntityHoverboard hoverboard = (EntityHoverboard)player.func_130014_f_().func_73045_a(this.entityID);
            if (player.field_70170_p.func_73045_a(this.entityProjectileID) != null) {
                Entity projectile = player.func_130014_f_().func_73045_a(this.entityProjectileID);
                Vec3i hoverboardPos = new Vec3i(hoverboard.field_70165_t, hoverboard.field_70163_u, hoverboard.field_70161_v);
                Vec3i projectilePos = new Vec3i(projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v);
                double distance = hoverboardPos.func_185332_f(projectilePos.func_177958_n(), projectilePos.func_177956_o(), projectilePos.func_177952_p()) + 0.1;
                Vec3i delta = new Vec3i(projectilePos.func_177958_n() - hoverboardPos.func_177958_n(), projectilePos.func_177952_p() - hoverboardPos.func_177956_o(), projectilePos.func_177952_p() - hoverboardPos.func_177952_p());
                projectile.field_70159_w += (double)delta.func_177958_n() / 0.5 / distance;
                projectile.field_70181_x += (double)delta.func_177956_o() / 0.5 / distance;
                projectile.field_70179_y += (double)delta.func_177952_p() / 0.5 / distance;
            }
        }
    }
}

