/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.arkifgames.hoverboardmod.crafting.builder.BuilderRecipes;
import com.arkifgames.hoverboardmod.inventory.ContainerBuilder;
import com.arkifgames.hoverboardmod.items.ItemHoverboard;
import com.arkifgames.hoverboardmod.network.PacketDispatcher;
import com.arkifgames.hoverboardmod.network.client.PacketTileEntityUpdate;
import com.arkifgames.hoverboardmod.tileentity.TileEntityMachine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityHoverboardBuilder
extends TileEntityMachine
implements ITickable {
    public static final int POWER_USAGE_TICK = 48;
    private static final int[] SLOTS_TOP = new int[0];
    private static final int[] SLOTS_BOTTOM = new int[]{16, 17, 18};
    private static final int[] SLOTS_SIDE = new int[]{16, 17, 18};
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)19, (Object)ItemStack.field_190927_a);
    private int inventoryWidthHeight = 4;
    public int buildTime;
    public int maxBuildTime;
    private boolean renderHoverboard;
    public IBlockState state;

    public TileEntityHoverboardBuilder() {
        super("container.hoverboardBuilder");
    }

    public ItemStack getStackInRowAndColumn(int row, int column) {
        if (row >= 0 && row < this.inventoryWidthHeight && column < this.inventoryWidthHeight && column >= 0) {
            int slot = row + column * this.inventoryWidthHeight;
            return this.func_70301_a(slot);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int getSizeCrafting() {
        return 16;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.items.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot >= this.func_70302_i_()) {
            return;
        }
        ItemStack itemStack1 = (ItemStack)this.items.get(slot);
        boolean flag = !itemStack.func_190926_b() && itemStack.func_77969_a(itemStack1) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemStack1);
        this.items.set(slot, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        if (slot < 16 && !flag) {
            this.buildTime = 0;
            this.func_70296_d();
        }
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_73660_a() {
        boolean flag = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.canBuild()) {
                if (this.getEnergyStored() >= 48) {
                    flag = true;
                    ++this.buildTime;
                    this.storage.extractEnergy(48, false);
                    if (this.buildTime >= this.maxBuildTime) {
                        this.buildTime = 0;
                        this.maxBuildTime = Integer.MAX_VALUE;
                        this.buildItem();
                        flag = true;
                    }
                }
            } else {
                this.buildTime = 0;
                this.maxBuildTime = Integer.MAX_VALUE;
            }
            if (this.renderHoverboard && !(this.func_70301_a(this.getSizeCrafting()).func_77973_b() instanceof ItemHoverboard)) {
                this.renderHoverboard = false;
                PacketDispatcher.sendToAll(new PacketTileEntityUpdate(this.field_174879_c, 0, 0));
            }
        }
        if (flag) {
            this.func_70296_d();
        }
        this.receiveEnergyFromSlot(this.items, this.getSizeCrafting() + 1);
        this.extractEnergyToSlot(this.items, this.getSizeCrafting() + 2);
    }

    private boolean canBuild() {
        boolean result;
        ItemStack itemStack = BuilderRecipes.getInstance().findMatchingRecipe(this);
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.items.get(this.getSizeCrafting())).func_190926_b()) {
            this.maxBuildTime = BuilderRecipes.getInstance().getBuildTime(itemStack.func_77973_b(), itemStack.func_77952_i());
            return true;
        }
        if (!((ItemStack)this.items.get(this.getSizeCrafting())).func_77969_a(itemStack)) {
            return false;
        }
        int stackSize = ((ItemStack)this.items.get(this.getSizeCrafting())).func_190916_E() + itemStack.func_190916_E();
        boolean bl = result = stackSize <= this.func_70297_j_() && stackSize <= ((ItemStack)this.items.get(this.getSizeCrafting())).func_77976_d();
        if (result) {
            this.maxBuildTime = BuilderRecipes.getInstance().getBuildTime(itemStack.func_77973_b(), itemStack.func_77952_i());
        }
        return result;
    }

    public void buildItem() {
        ItemStack itemStack = BuilderRecipes.getInstance().findMatchingRecipe(this);
        if (((ItemStack)this.items.get(this.getSizeCrafting())).func_190926_b()) {
            if (!this.field_145850_b.field_72995_K) {
                this.renderHoverboard = true;
                PacketDispatcher.sendToAll(new PacketTileEntityUpdate(this.field_174879_c, 0, 1));
            }
            this.items.set(this.getSizeCrafting(), (Object)itemStack.func_77946_l());
        } else if (((ItemStack)this.items.get(this.getSizeCrafting())).func_77973_b() == itemStack.func_77973_b()) {
            ((ItemStack)this.items.get(this.getSizeCrafting())).func_190917_f(itemStack.func_190916_E());
        }
        for (int i = 0; i < this.getSizeCrafting(); ++i) {
            if (((ItemStack)this.items.get(i)).func_190926_b()) continue;
            ((ItemStack)this.items.get(i)).func_190918_g(1);
            if (((ItemStack)this.items.get(i)).func_190916_E() > 0) continue;
            this.items.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbtTagCompound, this.items);
        this.buildTime = nbtTagCompound.func_74765_d("BuildTime");
        this.maxBuildTime = nbtTagCompound.func_74765_d("MaxBuildTime");
        this.renderHoverboard = nbtTagCompound.func_74767_n("RenderHoverboard");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("RenderHoverboard", this.renderHoverboard);
        nbtTagCompound.func_74777_a("MaxBuildTime", (short)this.maxBuildTime);
        nbtTagCompound.func_74777_a("BuildTime", (short)this.buildTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbtTagCompound, this.items);
        return nbtTagCompound;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(2.0);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == this.getSizeCrafting()) {
            return false;
        }
        if (slot > this.getSizeCrafting()) {
            return stack.func_77973_b() instanceof IEnergyContainerItem;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDE);
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing direction) {
        if (direction == EnumFacing.UP) {
            return false;
        }
        if (this.func_94041_b(slot, itemStack)) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            int energy = containerItem.getEnergyStored(itemStack);
            if (slot == 17 && energy > 0) {
                return true;
            }
            if (slot == 18 && energy <= 0) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing direction) {
        if (direction == EnumFacing.UP) {
            return false;
        }
        if (slot == 16) {
            return true;
        }
        if (this.func_94041_b(slot, itemStack)) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            int maxEnergy = containerItem.getMaxEnergyStored(itemStack);
            int energy = containerItem.getEnergyStored(itemStack);
            if (slot == 17 && (energy == 0 || this.getEnergyStored() == this.getMaxEnergyStored())) {
                return true;
            }
            if (slot == 18 && (energy == maxEnergy || this.getEnergyStored() <= 0)) {
                return true;
            }
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.buildTime;
            }
            case 1: {
                return this.getEnergyStored();
            }
            case 2: {
                return this.maxBuildTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.buildTime = value;
                break;
            }
            case 1: {
                this.setEnergyStored(value);
                break;
            }
            case 2: {
                this.maxBuildTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 3;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBuilder(playerInventory, this);
    }

    public String func_174875_k() {
        return "hoverboardmod:builder";
    }

    public void setRender(boolean render) {
        this.renderHoverboard = render;
    }

    public boolean getRenderHoverboard() {
        return this.renderHoverboard;
    }
}

