/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.arkifgames.hoverboardmod.entities.EntityHoverboard;
import com.arkifgames.hoverboardmod.inventory.ContainerCharger;
import com.arkifgames.hoverboardmod.tileentity.TileEntityOwner;
import com.arkifgames.hoverboardmod.util.Util;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileEntityHoverboardCharger
extends TileEntityOwner
implements ITickable {
    private static final int[] SLOTS = new int[]{0, 1};
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public boolean reverse;
    public IBlockState state;

    public TileEntityHoverboardCharger() {
        super("container.hoverboardCharger", 0x100000, 2048, 2048);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.items.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot >= this.func_70302_i_()) {
            return;
        }
        ItemStack itemStack1 = (ItemStack)this.items.get(slot);
        boolean flag = !itemStack.func_190926_b() && itemStack.func_77969_a(itemStack1) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemStack1);
        this.items.set(slot, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        if (!flag) {
            this.func_70296_d();
        }
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            List entities = this.field_145850_b.func_72872_a(EntityHoverboard.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b(4.0, 4.0, 4.0));
            if (entities.size() > 0) {
                EntityHoverboard hoverboard;
                int transfer = this.getMaxExtract() / entities.size();
                for (int i = 0; i < entities.size() && (!(hoverboard = (EntityHoverboard)((Object)entities.get(i))).getPrivateDock() || hoverboard.getOwnerUUID() == null || hoverboard.getOwnerUUID().equals(this.getOwnerUUID())); ++i) {
                    int receive;
                    int extract;
                    if (!this.reverse) {
                        extract = this.storage.extractEnergy(transfer, true);
                        if (extract > (receive = hoverboard.getSpaceForPower(transfer))) {
                            this.storage.extractEnergy(receive, false);
                            hoverboard.addPower(receive);
                        } else {
                            this.storage.extractEnergy(extract, false);
                            hoverboard.addPower(extract);
                        }
                        this.func_70296_d();
                        continue;
                    }
                    extract = hoverboard.getExtractPower(transfer);
                    if (extract > (receive = this.receiveEnergy(null, transfer, true))) {
                        hoverboard.addPower(-receive);
                        this.receiveEnergy(null, receive, false);
                    } else {
                        hoverboard.addPower(-extract);
                        this.receiveEnergy(null, extract, false);
                    }
                    this.func_70296_d();
                }
            }
        } else {
            List entities = this.field_145850_b.func_72872_a(EntityHoverboard.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b(4.0, 4.0, 4.0));
            if (entities.size() > 0) {
                for (int i = 0; i < entities.size(); ++i) {
                    int j;
                    EntityHoverboard hoverboard = (EntityHoverboard)((Object)entities.get(i));
                    if (this.reverse && hoverboard.hasPower() && this.getEnergyStored() < this.getMaxEnergyStored() || !this.reverse && hoverboard.getCurrentPower() < hoverboard.getMaxPower() && this.getEnergyStored() > 0) {
                        if (hoverboard.getPrivateDock() && hoverboard.getOwnerUUID() != null && !hoverboard.getOwnerUUID().equals(this.getOwnerUUID())) {
                            for (j = 0; j < hoverboard.chargers.size(); ++j) {
                                if (!hoverboard.chargers.get(j).compareTo(this.field_174879_c)) continue;
                                hoverboard.chargers.remove(j);
                            }
                            continue;
                        }
                        if (hoverboard.chargers.isEmpty()) {
                            hoverboard.chargers.add(new ChargerPos(this.field_174879_c, this.reverse));
                            continue;
                        }
                        boolean contains = false;
                        for (int j2 = 0; j2 < hoverboard.chargers.size(); ++j2) {
                            if (!hoverboard.chargers.get(j2).compareTo(this.field_174879_c)) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        hoverboard.chargers.add(new ChargerPos(this.field_174879_c, this.reverse));
                        continue;
                    }
                    for (j = 0; j < hoverboard.chargers.size(); ++j) {
                        if (!hoverboard.chargers.get(j).compareTo(this.field_174879_c)) continue;
                        hoverboard.chargers.remove(j);
                    }
                }
            }
        }
        if (this.getEnergyStored() > 0) {
            Util.pushEnergy(this.field_145850_b, this.field_174879_c, EnumFacing.DOWN, this.storage);
        }
        this.receiveEnergyFromSlot(this.items, 0);
        this.extractEnergyToSlot(this.items, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbtTagCompound, this.items);
        this.reverse = nbtTagCompound.func_74767_n("Reverse");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74757_a("Reverse", this.reverse);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbtTagCompound, this.items);
        return nbtTagCompound;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof IEnergyContainerItem;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == null) {
            return new int[0];
        }
        return side != EnumFacing.UP ? SLOTS : new int[]{};
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing direction) {
        if (this.func_94041_b(slot, itemStack)) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            int energy = containerItem.getEnergyStored(itemStack);
            if (slot == 0 && energy > 0) {
                return true;
            }
            if (slot == 1 && energy <= 0) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing direction) {
        if (this.func_94041_b(slot, itemStack)) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            int maxEnergy = containerItem.getMaxEnergyStored(itemStack);
            int energy = containerItem.getEnergyStored(itemStack);
            if (slot == 0 && (energy == 0 || this.getEnergyStored() == this.getMaxEnergyStored())) {
                return true;
            }
            if (slot == 1 && (energy == maxEnergy || this.getEnergyStored() <= 0)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        return facing != EnumFacing.UP;
    }

    @Override
    public int receiveEnergy(EnumFacing facing, int maxReceive, boolean simulate) {
        if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
            return this.storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.getEnergyStored();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.setEnergyStored(value);
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCharger(playerInventory, this);
    }

    public String func_174875_k() {
        return "hoverboardmod:charger";
    }

    public class ChargerPos {
        public int x;
        public int y;
        public int z;
        public boolean reverse;

        public ChargerPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public ChargerPos(BlockPos pos) {
            this.x = pos.func_177958_n();
            this.y = pos.func_177956_o();
            this.z = pos.func_177952_p();
        }

        public ChargerPos(BlockPos pos, boolean reverse) {
            this(pos);
            this.reverse = reverse;
        }

        public double distanceSq(double toX, double toY, double toZ) {
            double d0 = (double)this.x - toX;
            double d1 = (double)this.y - toY;
            double d2 = (double)this.z - toZ;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        public double distanceSq(Vec3i to) {
            return this.distanceSq(to.func_177958_n(), to.func_177956_o(), to.func_177952_p());
        }

        public BlockPos toBlockPos() {
            return new BlockPos(this.x, this.y, this.z);
        }

        public boolean compareTo(int x, int y, int z) {
            return this.x == x && this.y == y && this.z == z;
        }

        public boolean compareTo(BlockPos pos) {
            return this.compareTo(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }
}

