/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileEntityMachine
extends TileEntityLockable
implements ISidedInventory,
IEnergyReceiver {
    protected String guiName;
    protected String standardName;
    public boolean animationDone = false;
    public static final float POSITION_FINAL_TOP_LEFT = -12.5f;
    public static final float POSITION_FINAL_TOP_RIGHT = 12.5f;
    public float topLeftPosition = -2.5f;
    public float topRightPosition = 2.5f;
    private IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    private IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    private IItemHandler handlerNorth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
    private IItemHandler handlerEast = new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST);
    private IItemHandler handlerSouth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);
    private IItemHandler handlerWest = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
    protected EnergyStorage storage = new EnergyStorage(262144, 512, 512);

    public TileEntityMachine() {
    }

    public TileEntityMachine(String name) {
        this.standardName = name;
    }

    public TileEntityMachine(String name, int energy, int energyReceive, int energyExtract) {
        this.standardName = name;
        this.storage = new EnergyStorage(energy, energyReceive, energyExtract);
    }

    public int func_70302_i_() {
        return 0;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.guiName : this.standardName;
    }

    public boolean func_145818_k_() {
        return this.guiName != null && this.guiName.length() > 0;
    }

    public void setCustomInventoryName(String name) {
        this.guiName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.animationDone = nbtTagCompound.func_74767_n("Animate");
        if (nbtTagCompound.func_74764_b("CustomName")) {
            this.guiName = nbtTagCompound.func_74779_i("CustomName");
        }
        if (this.storage != null) {
            this.storage.readFromNBT(nbtTagCompound);
        }
        if (this.animationDone) {
            this.topRightPosition = 12.5f;
            this.topLeftPosition = -12.5f;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        if (this.storage != null) {
            this.storage.writeToNBT(nbtTagCompound);
        }
        if (this.func_145818_k_()) {
            nbtTagCompound.func_74778_a("CustomName", this.guiName);
        }
        nbtTagCompound.func_74757_a("Animate", this.animationDone);
        return nbtTagCompound;
    }

    protected void receiveEnergyFromSlot(NonNullList<ItemStack> items, int slot) {
        if (!((ItemStack)items.get(slot)).func_190926_b() && ((ItemStack)items.get(slot)).func_77973_b() instanceof IEnergyContainerItem) {
            int receive;
            IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)((ItemStack)items.get(slot)).func_77973_b();
            int extract = energyContainerItem.extractEnergy((ItemStack)items.get(slot), 512, true);
            if (extract > (receive = this.storage.receiveEnergy(extract, true))) {
                energyContainerItem.extractEnergy((ItemStack)items.get(slot), receive, false);
                this.storage.receiveEnergy(receive, false);
            } else {
                energyContainerItem.extractEnergy((ItemStack)items.get(slot), extract, false);
                this.storage.receiveEnergy(extract, false);
            }
            this.func_70296_d();
        }
    }

    protected void extractEnergyToSlot(NonNullList<ItemStack> items, int slot) {
        if (!((ItemStack)items.get(slot)).func_190926_b() && ((ItemStack)items.get(slot)).func_77973_b() instanceof IEnergyContainerItem) {
            int receive;
            IEnergyContainerItem energyContainerItem = (IEnergyContainerItem)((ItemStack)items.get(slot)).func_77973_b();
            int extract = this.storage.extractEnergy(512, true);
            if (extract > (receive = energyContainerItem.receiveEnergy((ItemStack)items.get(slot), 512, true))) {
                this.storage.extractEnergy(receive, false);
                energyContainerItem.receiveEnergy((ItemStack)items.get(slot), receive, false);
            } else {
                this.storage.extractEnergy(extract, false);
                energyContainerItem.receiveEnergy((ItemStack)items.get(slot), extract, false);
            }
            this.func_70296_d();
        }
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return from == EnumFacing.DOWN;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (from == EnumFacing.DOWN) {
            return this.storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public int getMaxExtract() {
        return this.storage.getMaxExtract();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            if (facing == EnumFacing.NORTH) {
                return (T)this.handlerNorth;
            }
            if (facing == EnumFacing.EAST) {
                return (T)this.handlerEast;
            }
            if (facing == EnumFacing.SOUTH) {
                return (T)this.handlerSouth;
            }
            if (facing == EnumFacing.WEST) {
                return (T)this.handlerWest;
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

