/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.arkifgames.hoverboardmod.crafting.MeltSpinnerRecipes;
import com.arkifgames.hoverboardmod.inventory.ContainerMeltSpinner;
import com.arkifgames.hoverboardmod.tileentity.TileEntityMachine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;

public class TileEntityMeltSpinner
extends TileEntityMachine
implements ITickable {
    public static final int POWER_USAGE_TICK = 64;
    public static final int TICKS_TO_SPIN = 200;
    private static final int[] SLOTS_TOP = new int[]{0, 2, 3};
    private static final int[] SLOTS_BOTTOM = new int[]{1, 2, 3};
    private static final int[] SLOTS_SIDE = new int[]{0, 2, 3};
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int spinnerTime;
    public float zRotation;
    private boolean synced;

    public TileEntityMeltSpinner() {
        super("container.meltSpinner");
    }

    @Override
    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.items.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot >= this.func_70302_i_()) {
            return;
        }
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        boolean flag = !itemStack.func_190926_b() && itemStack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemstack);
        this.items.set(slot, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        if (slot < 1 && !flag) {
            this.spinnerTime = 0;
            this.func_70296_d();
        }
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_73660_a() {
        boolean flag = false;
        if (!this.field_145850_b.field_72995_K) {
            if (this.canSpin()) {
                if (this.getEnergyStored() >= 64) {
                    flag = true;
                    ++this.spinnerTime;
                    this.storage.extractEnergy(64, false);
                    if (this.spinnerTime >= 200) {
                        this.spinnerTime = 0;
                        this.spinItem();
                        flag = true;
                    }
                    this.synced = false;
                } else if (!this.synced) {
                    IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 1);
                    this.synced = true;
                }
            } else {
                this.spinnerTime = 0;
                if (!this.synced) {
                    IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, blockState, blockState, 1);
                    this.synced = true;
                }
            }
        }
        if (flag) {
            this.func_70296_d();
        }
        if (this.field_145850_b.field_72995_K) {
            this.zRotation = this.spinnerTime != 0 && this.getEnergyStored() >= 64 ? (this.zRotation < 360.0f ? (this.zRotation += 9.0f) : 0.0f) : 0.0f;
        }
        this.receiveEnergyFromSlot(this.items, 2);
        this.extractEnergyToSlot(this.items, 3);
    }

    private boolean canSpin() {
        ItemStack itemstack;
        if (((ItemStack)this.items.get(0)).func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.items.get(1)).func_77973_b() == Items.field_190931_a) {
            this.items.set(1, (Object)ItemStack.field_190927_a);
        }
        if ((itemstack = MeltSpinnerRecipes.instance().getSmeltingResult((ItemStack)this.items.get(0))).func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.items.get(1)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.items.get(1)).func_77969_a(itemstack)) {
            return false;
        }
        int result = ((ItemStack)this.items.get(1)).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= ((ItemStack)this.items.get(1)).func_77976_d();
    }

    public void spinItem() {
        ItemStack itemstack = MeltSpinnerRecipes.instance().getSmeltingResult((ItemStack)this.items.get(0));
        if (((ItemStack)this.items.get(1)).func_190926_b()) {
            this.items.set(1, (Object)itemstack.func_77946_l());
        } else if (((ItemStack)this.items.get(1)).func_77973_b() == itemstack.func_77973_b()) {
            ((ItemStack)this.items.get(1)).func_190917_f(itemstack.func_190916_E());
        }
        ((ItemStack)this.items.get(0)).func_190918_g(1);
        if (((ItemStack)this.items.get(0)).func_190916_E() <= 0) {
            this.items.set(0, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbtTagCompound, this.items);
        this.spinnerTime = nbtTagCompound.func_74765_d("SpinnerTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74777_a("SpinnerTime", (short)this.spinnerTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbtTagCompound, this.items);
        return nbtTagCompound;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return false;
        }
        if (slot == 2 || slot == 3) {
            return itemStack.func_77973_b() instanceof IEnergyContainerItem;
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing direction) {
        return direction == EnumFacing.DOWN ? SLOTS_BOTTOM : (direction == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDE);
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN) {
            return false;
        }
        if (slot == 2 || slot == 3) {
            if (this.func_94041_b(slot, itemStack)) {
                IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
                int energy = containerItem.getEnergyStored(itemStack);
                if (slot == 2 && energy > 0) {
                    return true;
                }
                if (slot == 3 && energy <= 0) {
                    return true;
                }
            }
            return false;
        }
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing direction) {
        if (direction == EnumFacing.DOWN && slot == 1) {
            return true;
        }
        if (direction == EnumFacing.UP && slot == 0) {
            return true;
        }
        if (direction != EnumFacing.DOWN && direction != EnumFacing.UP && slot == 1) {
            return true;
        }
        if (slot == 2 || slot == 3) {
            if (this.func_94041_b(slot, itemStack)) {
                IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
                int maxEnergy = containerItem.getMaxEnergyStored(itemStack);
                int energy = containerItem.getEnergyStored(itemStack);
                if (slot == 2 && (energy == 0 || this.getEnergyStored() == this.getMaxEnergyStored())) {
                    return true;
                }
                if (slot == 3 && (energy == maxEnergy || this.getEnergyStored() <= 0)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        if (from == EnumFacing.DOWN) {
            return true;
        }
        if (this.func_145832_p() == 2 && from == EnumFacing.SOUTH) {
            return true;
        }
        if (this.func_145832_p() == 3 && from == EnumFacing.NORTH) {
            return true;
        }
        if (this.func_145832_p() == 4 && from == EnumFacing.EAST) {
            return true;
        }
        return this.func_145832_p() == 5 && from == EnumFacing.WEST;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (from == EnumFacing.DOWN || this.func_145832_p() == 2 && from == EnumFacing.SOUTH || this.func_145832_p() == 3 && from == EnumFacing.NORTH || this.func_145832_p() == 4 && from == EnumFacing.EAST || this.func_145832_p() == 5 && from == EnumFacing.WEST) {
            return this.storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.spinnerTime;
            }
            case 1: {
                return this.getEnergyStored();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.spinnerTime = value;
                break;
            }
            case 1: {
                this.setEnergyStored(value);
            }
        }
    }

    public int func_174890_g() {
        return 2;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerMeltSpinner(playerInventory, this);
    }

    public String func_174875_k() {
        return "hoverboardmod:meltSpinner";
    }
}

