/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.arkifgames.hoverboardmod.inventory.ContainerSolarPanel;
import com.arkifgames.hoverboardmod.tileentity.TileEntityMachine;
import com.arkifgames.hoverboardmod.util.Util;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;

public class TileEntitySolarPanel
extends TileEntityMachine
implements ITickable {
    public static final float ROTATION_X_MIN = -15.0f;
    public static final float ROTATION_X_MAX = 15.0f;
    public static final float HYDRAULIC_OFFSET_MIN = -0.125f;
    public static final float HYDRAULIC_OFFSET_MAX = 0.0f;
    public float xRotation = 0.0f;
    public float hydraulicOffsetFront = 0.0f;
    public float hydraulicOffsetBack = 0.0f;
    private static final int CONTINUOUS_GENERATION = 16;
    private static final int ADDITIONAL_GENERATION_MIN = 0;
    private static final int ADDITIONAL_GENERATION_MAX = 32;
    private static final int[] SLOTS_BOTTOM = new int[]{0};
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public TileEntitySolarPanel() {
        super("container.solarPanel");
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.items.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (slot >= this.func_70302_i_()) {
            return;
        }
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        boolean flag = !itemStack.func_190926_b() && itemStack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemstack);
        this.items.set(slot, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        if (!flag) {
            this.func_70296_d();
        }
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_73660_a() {
        long worldTime = this.field_145850_b.func_72820_D() - this.field_145850_b.func_72820_D() / 24000L * 24000L;
        if (this.field_145850_b.field_73011_w.func_191066_m()) {
            if (worldTime > 23459L || worldTime < 12542L) {
                if (worldTime > 23459L) {
                    this.xRotation = Util.remap(23460.0f, 36540.0f, -15.0f, 15.0f, worldTime);
                } else if (worldTime < 12542L) {
                    this.xRotation = Util.remap(0.0f, 12541.0f, -13.7637615f, 15.0f, worldTime);
                }
                this.xRotation *= -1.0f;
                if (this.xRotation > 0.0f) {
                    this.hydraulicOffsetFront = Util.remap(0.0f, 15.0f, -0.125f, 0.0f, this.xRotation);
                    this.hydraulicOffsetBack = -0.125f - Util.remap(0.0f, 15.0f, -0.125f, 0.0f, this.xRotation);
                } else if (this.xRotation < 0.0f) {
                    this.hydraulicOffsetBack = Util.remap(0.0f, -15.0f, -0.125f, 0.0f, this.xRotation);
                    this.hydraulicOffsetFront = -0.125f - Util.remap(0.0f, -15.0f, -0.125f, 0.0f, this.xRotation);
                } else {
                    this.hydraulicOffsetFront = 0.0f;
                    this.hydraulicOffsetBack = 0.0f;
                }
                if (this.field_145850_b.func_175710_j(this.field_174879_c)) {
                    int generation = 16;
                    if (!this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I()) {
                        generation = (int)((float)generation + Util.remap(0.0f, 15.0f, 0.0f, 32.0f, 15.0f - Math.abs(this.xRotation)));
                    }
                    this.storage.receiveEnergy(generation, false);
                    this.func_70296_d();
                }
            } else if (this.xRotation < 15.0f) {
                this.xRotation += 0.05f;
                if (this.xRotation > 0.0f) {
                    this.hydraulicOffsetFront = Util.remap(0.0f, 15.0f, -0.125f, 0.0f, this.xRotation);
                    this.hydraulicOffsetBack = -0.125f - Util.remap(0.0f, 15.0f, -0.125f, 0.0f, this.xRotation);
                } else if (this.xRotation < 0.0f) {
                    this.hydraulicOffsetBack = Util.remap(0.0f, -15.0f, -0.125f, 0.0f, this.xRotation);
                    this.hydraulicOffsetFront = -0.125f - Util.remap(0.0f, -15.0f, -0.125f, 0.0f, this.xRotation);
                }
            } else {
                this.xRotation = 15.0f;
                this.hydraulicOffsetFront = 0.0f;
                this.hydraulicOffsetBack = -0.125f;
            }
        }
        if (this.getEnergyStored() > 0) {
            Util.pushEnergy(this.field_145850_b, this.field_174879_c, EnumFacing.DOWN, this.storage);
            this.func_70296_d();
        }
        this.extractEnergyToSlot(this.items, 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbtTagCompound, this.items);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbtTagCompound, this.items);
        return nbtTagCompound;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof IEnergyContainerItem;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : new int[]{};
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing direction) {
        if (this.func_94041_b(slot, itemStack)) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            int maxEnergy = containerItem.getMaxEnergyStored(itemStack);
            int energy = containerItem.getEnergyStored(itemStack);
            if (slot == 0 && energy < maxEnergy) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing direction) {
        if (this.func_94041_b(slot, itemStack)) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            int maxEnergy = containerItem.getMaxEnergyStored(itemStack);
            int energy = containerItem.getEnergyStored(itemStack);
            if (slot == 0 && energy >= maxEnergy) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int receiveEnergy(EnumFacing facing, int maxReceive, boolean simulate) {
        return 0;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.getEnergyStored();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.setEnergyStored(value);
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSolarPanel(playerInventory, this);
    }

    public String func_174875_k() {
        return "hoverboardmod:solarPanel";
    }
}

