/*
 * Decompiled with CFR 0.152.
 */
package com.arkifgames.hoverboardmod.util;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import java.math.BigDecimal;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Util {
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String END = "\u00a7r";

    public static String shiftForDetails() {
        return TextFormatting.GRAY + I18n.func_135052_a((String)"info.hoverboardmod.hold", (Object[])new Object[0]) + " " + TextFormatting.DARK_PURPLE + ITALIC + I18n.func_135052_a((String)"info.hoverboardmod.shift", (Object[])new Object[0]) + END + TextFormatting.GRAY + " " + I18n.func_135052_a((String)"info.hoverboardmod.forInformation", (Object[])new Object[0]) + END;
    }

    public static float round(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Float.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd.floatValue();
    }

    public static float roundFloat(float number, int scale) {
        int pow = 10;
        for (int i = 1; i < scale; ++i) {
            pow *= 10;
        }
        float tmp = number * (float)pow;
        return (float)((int)(tmp - (float)((int)tmp) >= 0.5f ? tmp + 1.0f : tmp)) / (float)pow;
    }

    public static float remap(float oldMin, float oldMax, float newMin, float newMax, float value) {
        float oldRange = oldMax - oldMin;
        float newRange = newMax - newMin;
        float newValue = (value - oldMin) * newRange / oldRange + newMin;
        return newValue;
    }

    public static int remap(int oldMin, int oldMax, int newMin, int newMax, int value) {
        float oldRange = oldMax - oldMin;
        float newRange = newMax - newMin;
        float newValue = (float)(value - oldMin) * newRange / oldRange + (float)newMin;
        return Math.round(newValue);
    }

    public static void pushEnergy(World world, BlockPos blockPos, EnumFacing side, EnergyStorage storage) {
        TileEntity tileEntity = Util.getTileEntityFromSide(side, world, blockPos);
        if (tileEntity != null && tileEntity instanceof IEnergyReceiver && storage.getEnergyStored() > 0 && ((IEnergyReceiver)tileEntity).canConnectEnergy(side.func_176734_d())) {
            int receive = ((IEnergyReceiver)tileEntity).receiveEnergy(side.func_176734_d(), Math.min(storage.getMaxExtract(), storage.getEnergyStored()), false);
            storage.extractEnergy(receive, false);
        }
    }

    public static TileEntity getTileEntityFromSide(EnumFacing side, World world, BlockPos blockPos) {
        return world.func_175625_s(new BlockPos(blockPos.func_177958_n() + side.func_82601_c(), blockPos.func_177956_o() + side.func_96559_d(), blockPos.func_177952_p() + side.func_82599_e()));
    }

    public static ItemStack copyTag(ItemStack container, ItemStack other) {
        if (!other.func_190926_b() && other.func_77942_o()) {
            container.func_77982_d(other.func_77978_p().func_74737_b());
        }
        return container;
    }

    public static ItemStack setDefaultEnergyTag(ItemStack container, int energy) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        container.func_77978_p().func_74768_a("Energy", energy);
        return container;
    }

    public static void removeFakeItems(EntityPlayer entityPlayer, Container container) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityPlayer;
            for (int i = 0; i < container.field_75151_b.size(); ++i) {
                if (container.field_75151_b.get(i) == null || ((Slot)container.field_75151_b.get(i)).func_75211_c().func_190926_b() || !((Slot)container.field_75151_b.get(i)).func_75216_d() || ((Slot)container.field_75151_b.get(i)).func_75211_c().func_190916_E() != 0) continue;
                ((Slot)container.field_75151_b.get(i)).func_75215_d(ItemStack.field_190927_a);
            }
            entityPlayerMP.func_71120_a(container);
        }
    }

    public static float getRotationTESR(int i) {
        int j = 0;
        if (i == 2) {
            j = 180;
        }
        if (i == 3) {
            j = 0;
        }
        if (i == 4) {
            j = 90;
        }
        if (i == 5) {
            j = -90;
        }
        return j;
    }

    public static NBTTagCompound saveAllItems(NBTTagCompound tag, NonNullList<ItemStack> list, boolean saveEmpty) {
        NBTTagList nbttaglist = new NBTTagList();
        for (short i = 0; i < list.size(); i = (short)((short)(i + 1))) {
            ItemStack itemstack = (ItemStack)list.get((int)i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74777_a("Slot", i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d() || saveEmpty) {
            tag.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        return tag;
    }

    public static void loadAllItems(NBTTagCompound tag, NonNullList<ItemStack> list) {
        NBTTagList nbttaglist = tag.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            short j = nbttagcompound.func_74765_d("Slot");
            if (j < 0 || j >= list.size()) continue;
            list.set((int)j, (Object)new ItemStack(nbttagcompound));
        }
    }
}

