/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.thedragonteam.thedragonlib.api.IDataRetainerTile;
import net.thedragonteam.thedragonlib.util.ItemNBTHelper;

public class BlockDLib
extends Block {
    public static final String TILE_DATA_TAG = "SMTileData";
    protected boolean isFullCube = true;

    public BlockDLib() {
        this(Material.field_151576_e);
    }

    public BlockDLib(Material material) {
        super(material);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        super.func_149666_a(item, tab, list);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IDataRetainerTile && ItemNBTHelper.getCompound(stack).func_74764_b(TILE_DATA_TAG)) {
            ((IDataRetainerTile)tile).readDataFromNBT(ItemNBTHelper.getCompound(stack).func_74775_l(TILE_DATA_TAG));
        }
    }

    public BlockDLib setHarvestTool(String toolClass, int level) {
        this.setHarvestLevel(toolClass, level);
        return this;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity;
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (stack.func_77973_b() == Item.func_150898_a((Block)this) && stack.func_77973_b().func_77614_k()) {
            stack.func_77964_b(this.func_176201_c(state));
        }
        if ((tileEntity = world.func_175625_s(pos)) instanceof IDataRetainerTile) {
            NBTTagCompound customData = new NBTTagCompound();
            ((IDataRetainerTile)tileEntity).writeDataToNBT(customData);
            ItemNBTHelper.getCompound(stack).func_74782_a(TILE_DATA_TAG, (NBTBase)customData);
        }
        return stack;
    }

    public BlockDLib setIsFullCube(boolean value) {
        this.isFullCube = value;
        return this;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack heldStack) {
        if (te instanceof IDataRetainerTile) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()));
            NBTTagCompound customData = new NBTTagCompound();
            ((IDataRetainerTile)te).writeDataToNBT(customData);
            ItemNBTHelper.getCompound(stack).func_74782_a(TILE_DATA_TAG, (NBTBase)customData);
            BlockDLib.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            world.func_175713_t(pos);
        } else {
            super.func_180657_a(world, player, pos, state, te, heldStack);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isFullCube;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isFullCube;
    }
}

