/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.thedragonlib.blocks.ItemBlockDLib;
import net.thedragonteam.thedragonlib.config.Feature;
import net.thedragonteam.thedragonlib.config.FeatureWrapper;
import net.thedragonteam.thedragonlib.config.ICustomRegistry;
import net.thedragonteam.thedragonlib.config.ICustomRender;
import net.thedragonteam.thedragonlib.config.IRegisterMyOwnTiles;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class ModFeatureParser {
    private String modid;
    private CreativeTabs[] modTabs;
    private static final String CATEGORY_BLOCKS = "Blocks";
    private static final String CATEGORY_ITEMS = "Items";
    private static final Map<Object, Boolean> featureStates = new HashMap<Object, Boolean>();
    private static final List<FeatureEntry> featureEntries = new ArrayList<FeatureEntry>();

    public ModFeatureParser(String modid, CreativeTabs[] modTabs) {
        this.modid = modid;
        this.modTabs = modTabs;
    }

    public void loadFeatures(Class collection) {
        for (Field field : collection.getFields()) {
            if (!field.isAnnotationPresent(Feature.class)) continue;
            try {
                featureEntries.add(new FeatureEntry(field.get(null), field.getAnnotation(Feature.class)));
            }
            catch (IllegalAccessException e) {
                LogHelper.error("Error Loading Feature!!! [" + field.getAnnotation(Feature.class).name() + "]");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFeatureConfig(Configuration configuration) {
        try {
            for (FeatureEntry entry : featureEntries) {
                if (!entry.feature.isConfigurable()) {
                    featureStates.put(entry.featureObj, true);
                    continue;
                }
                String category = entry.featureObj instanceof Block ? CATEGORY_BLOCKS : CATEGORY_ITEMS;
                entry.enabled = configuration.get(category, entry.feature.name(), entry.feature.isActive()).getBoolean(entry.feature.isActive());
                featureStates.put(entry.featureObj, entry.enabled);
            }
        }
        catch (Exception var4) {
            LogHelper.error("Error Loading Block/Item Config");
            var4.printStackTrace();
        }
        finally {
            if (configuration.hasChanged()) {
                configuration.save();
            }
        }
    }

    public void registerFeatures() {
        for (FeatureEntry entry : featureEntries) {
            if (!entry.enabled) continue;
            if (entry.featureObj instanceof ICustomRegistry) {
                ((ICustomRegistry)entry.featureObj).registerFeature(entry.feature);
                continue;
            }
            if (entry.featureObj instanceof Block) {
                Block block = (Block)entry.featureObj;
                block.setRegistryName(entry.feature.name());
                block.func_149663_c(this.modid.toLowerCase() + ":" + entry.feature.name());
                if (entry.feature.cTab() >= 0 && entry.feature.cTab() < this.modTabs.length) {
                    block.func_149647_a(this.modTabs[entry.feature.cTab()]);
                }
                if (ItemBlockDLib.class.isAssignableFrom(entry.feature.itemBlock())) {
                    GameRegistry.register((IForgeRegistryEntry)block);
                    try {
                        Constructor<? extends ItemBlock> constructor = entry.feature.itemBlock().getConstructor(Block.class, FeatureWrapper.class);
                        ItemBlock itemBlock = constructor.newInstance(block, new FeatureWrapper(entry.feature));
                        itemBlock.setRegistryName(block.getRegistryName());
                        GameRegistry.register((IForgeRegistryEntry)itemBlock);
                    }
                    catch (Exception e) {
                        LogHelper.error("Well... It broke... [%s]", entry.feature.name());
                        e.printStackTrace();
                    }
                } else {
                    GameRegistry.register((IForgeRegistryEntry)block);
                    GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(block.getRegistryName()));
                }
                if (!block.hasTileEntity(block.func_176223_P())) continue;
                if (block instanceof IRegisterMyOwnTiles) {
                    ((IRegisterMyOwnTiles)block).registerTiles(this.modid.toLowerCase() + ":", entry.feature.name());
                    continue;
                }
                GameRegistry.registerTileEntity(entry.feature.tileEntity(), (String)(this.modid.toLowerCase() + ":" + entry.feature.name()));
                continue;
            }
            if (!(entry.featureObj instanceof Item)) continue;
            Item item = (Item)entry.featureObj;
            item.setRegistryName(entry.feature.name());
            item.func_77655_b(this.modid.toLowerCase() + ":" + entry.feature.name());
            if (entry.feature.cTab() >= 0 && entry.feature.cTab() < this.modTabs.length) {
                item.func_77637_a(this.modTabs[entry.feature.cTab()]);
            }
            GameRegistry.register((IForgeRegistryEntry)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRendering() {
        for (FeatureEntry entry : featureEntries) {
            if (!entry.enabled) continue;
            if (entry.featureObj instanceof ICustomRender) {
                ICustomRender customRender = (ICustomRender)entry.featureObj;
                customRender.registerRenderer(entry.feature);
                if (!customRender.registerNormal(entry.feature)) continue;
            }
            if (entry.featureObj instanceof Block) {
                Block block = (Block)entry.featureObj;
                if (entry.feature.variantMap().length > 0) {
                    this.registerVariants(Item.func_150898_a((Block)block), entry.feature);
                    continue;
                }
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modid.toLowerCase() + ":" + entry.feature.name()));
                continue;
            }
            if (!(entry.featureObj instanceof Item)) continue;
            Item item = (Item)entry.featureObj;
            if (!entry.feature.stateOverride().isEmpty()) {
                String s = entry.feature.stateOverride().substring(0, entry.feature.stateOverride().indexOf("#"));
                s = s + entry.feature.stateOverride().substring(entry.feature.stateOverride().indexOf("#")).toLowerCase();
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modid.toLowerCase() + ":" + s));
                continue;
            }
            if (entry.feature.variantMap().length > 0) {
                this.registerVariants(item, entry.feature);
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.modid.toLowerCase() + ":" + entry.feature.name()));
        }
    }

    private void registerVariants(Item item, Feature feature) {
        for (String s : feature.variantMap()) {
            int meta = Integer.parseInt(s.substring(0, s.indexOf(":")));
            String fullName = this.modid.toLowerCase() + ":" + feature.name();
            String variant = s.substring(s.indexOf(":") + 1);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(fullName, variant));
        }
    }

    public static boolean isFeature(Object object) {
        return featureStates.containsKey(object);
    }

    public static boolean isEnabled(Object feature) {
        if (!featureStates.containsKey(feature)) {
            return false;
        }
        return featureStates.get(feature);
    }

    private static class FeatureEntry {
        private final Object featureObj;
        private final Feature feature;
        public boolean enabled;

        private FeatureEntry(Object featureObj, Feature feature) {
            this.featureObj = featureObj;
            this.feature = feature;
            this.enabled = feature.isActive();
        }
    }
}

