/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.thedragonteam.thedragonlib.lib.Vec3D;

public class Utils {
    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (value < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1000000000L) {
            return String.valueOf((double)Math.round(value / 1000L) / 1000.0) + "M";
        }
        if (value < 1000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000L) / 1000.0) + "B";
        }
        if (value < 1000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000L) / 1000.0) + "T";
        }
        if (value < 1000000000000000000L) {
            return String.valueOf((double)Math.round(value / 1000000000000L) / 1000.0) + "Quad";
        }
        if (value <= Long.MAX_VALUE) {
            return String.valueOf((double)Math.round(value / 1000000000000000L) / 1000.0) + "Quin";
        }
        return "Something is very broken!!!!";
    }

    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistanceAtoB(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistanceAtoB(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static boolean isConnectedToDedicatedServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() == null;
    }

    public static void updateNeabourBlocks(World world, BlockPos pos) {
        world.func_180496_d(pos, world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177982_a(-1, 0, 0), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177982_a(1, 0, 0), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177982_a(0, -1, 0), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177982_a(0, 1, 0), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177982_a(0, 0, -1), world.func_180495_p(pos).func_177230_c());
        world.func_180496_d(pos.func_177982_a(0, 0, 1), world.func_180495_p(pos).func_177230_c());
    }

    public static int determineOrientation(int x, int y, int z, EntityLivingBase entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + 1.82 - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : (l == 3 ? 5 : 0)));
    }

    public static double round(double number, double multiplier) {
        return (double)Math.round(number * multiplier) / multiplier;
    }

    public static int getNearestMultiple(int number, int multiple) {
        int result = number;
        if (number < 0) {
            result *= -1;
        }
        if (result % multiple == 0) {
            return number;
        }
        result = result % multiple < multiple / 2 ? (result -= result % multiple) : (result += multiple - result % multiple);
        if (number < 0) {
            result *= -1;
        }
        return result;
    }

    public static int toInt(double d) {
        return (int)d;
    }
}

