/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.api.recipe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class HighTechBenchRecipe {
    protected ItemStack output = null;
    protected ArrayList<Object> input = new ArrayList();

    public HighTechBenchRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public HighTechBenchRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public HighTechBenchRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid High-Tech Bench recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput(List<ItemStack> inputList) {
        return this.output.func_77946_l();
    }

    public boolean matches(List<ItemStack> checkedList, World world, BlockPos pos) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (ItemStack slot : checkedList) {
            if (slot == null) continue;
            boolean inRecipe = false;
            for (Object aRequired : required) {
                boolean match = false;
                if (aRequired instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)aRequired), (ItemStack)slot, (boolean)false);
                } else if (aRequired instanceof List) {
                    Iterator itr = ((List)aRequired).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(aRequired);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }

    public ItemStack[] getRemainingItems(ItemStack[] inventory) {
        ItemStack[] ret = (ItemStack[])inventory.clone();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getContainerItem(inventory[i]);
        }
        return ret;
    }

    protected ItemStack getContainerItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemStack copyStack = stack.func_77946_l();
        if (copyStack.func_77973_b().hasContainerItem(stack)) {
            return copyStack.func_77973_b().getContainerItem(copyStack);
        }
        --copyStack.field_77994_a;
        if (copyStack.field_77994_a <= 0) {
            return null;
        }
        return copyStack;
    }
}

