/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors.base;

import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.base.BaseARPTeslaContainerProvider;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.TextHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla")})
public class BaseSteelArmor
extends ItemArmor
implements ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
IEnergyContainerItem {
    public static ItemArmor.ArmorMaterial steelArmorNotPowered = EnumHelper.addArmorMaterial((String)"steelArmor", (String)ArmorPlus.getArmorPlusLocation("steel_armor"), (int)15, (int[])APConfig.steelArmorProtectionPoints, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)((float)APConfig.steelArmorToughnessPoints));
    private int power;
    private int maxCapacity;
    private int output;
    private int input;

    public BaseSteelArmor(EntityEquipmentSlot slot, int maxCapacity, int input, int output) {
        super(steelArmorNotPowered, 0, slot);
        this.func_77625_d(1);
        switch (slot) {
            case FEET: {
                String boots = "steel_boots";
                this.setRegistryName(boots);
                this.func_77655_b(Utils.setName(boots));
                break;
            }
            case LEGS: {
                String leggings = "steel_leggings";
                this.setRegistryName(leggings);
                this.func_77655_b(Utils.setName(leggings));
                break;
            }
            case CHEST: {
                String chestplate = "steel_chestplate";
                this.setRegistryName(chestplate);
                this.func_77655_b(Utils.setName(chestplate));
                break;
            }
            case HEAD: {
                String helmet = "steel_helmet";
                this.setRegistryName(helmet);
                this.func_77655_b(Utils.setName(helmet));
            }
        }
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77637_a(ArmorPlus.tabArmorplusRF);
        this.power = 0;
        this.maxCapacity = maxCapacity;
        this.output = output;
        this.input = input;
    }

    public String func_77653_i(ItemStack stack) {
        return (TextFormatting.func_96300_b((String)APConfig.steelArmorItemNameColor) + TextHelper.localize((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(toRepair, (Item)ModItems.steelIngot, (Block)ModBlocks.steelBlock);
    }

    @Optional.Method(modid="tesla")
    public long givePower(long power, boolean simulated) {
        return this.input;
    }

    @Optional.Method(modid="tesla")
    public long takePower(long power, boolean simulated) {
        return this.output;
    }

    @Optional.Method(modid="tesla")
    public long getStoredPower() {
        return this.power;
    }

    @Optional.Method(modid="tesla")
    public long getCapacity() {
        return this.maxCapacity;
    }

    public BaseSteelArmor setCapacity(int capacity) {
        this.maxCapacity = capacity;
        return this;
    }

    public int getPower() {
        return this.power;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (player.field_70737_aN > 0) {
            this.extractEnergy(itemStack, APConfig.outputSteelArmor, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    private int createPoweredStack(ItemStack container, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", APConfig.maxCapacitySteelArmor);
        }
        return APConfig.maxCapacitySteelArmor;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack powered = new ItemStack(itemIn, 1, 1);
        ItemStack unpowered = new ItemStack(itemIn);
        this.poweredItem(powered);
        subItems.add(powered);
        this.createPoweredStack(powered, false);
        subItems.add(unpowered);
    }

    private int poweredItem(ItemStack itemStack) {
        return this.receiveEnergy(itemStack, this.getMaxEnergyStored(itemStack), false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() == 1) {
            this.createPoweredStack(stack, false);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="tesla")
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"", (Object[])new Object[0]) + this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack) + I18n.func_135052_a((String)" RF", (Object[])new Object[0]));
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.rf.cost.tool", (Object[])new Object[]{Integer.toString(this.getMaxReceive(stack))}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.rf.showinfo", (Object[])new Object[]{TextFormatting.DARK_RED, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }

    @Optional.Method(modid="tesla")
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BaseARPTeslaContainerProvider(new BaseTeslaContainer(), this.power, this.maxCapacity, this.output, this.input);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxCapacity;
    }

    public BaseSteelArmor setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public BaseSteelArmor setMaxReceive(int maxReceive) {
        this.input = maxReceive;
        return this;
    }

    public BaseSteelArmor setMaxExtract(int maxExtract) {
        this.output = maxExtract;
        return this;
    }

    public int getMaxExtract(ItemStack container) {
        return this.output;
    }

    public int getMaxReceive(ItemStack container) {
        return this.input;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.maxCapacity - energy, Math.min(this.input, maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.output, maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy") ? 0 : (this.power = container.func_77978_p().func_74762_e("Energy"));
    }
}

