/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.armors.base;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.TextHelper;

public class BaseUltimateArmor
extends ItemArmor {
    public static ItemArmor.ArmorMaterial theUltimateArmor = EnumHelper.addArmorMaterial((String)"theUltimateArmor", (String)ArmorPlus.getArmorPlusLocation("the_ultimate_armor"), (int)160, (int[])APConfig.theUltimateArmorProtectionPoints, (int)1, (SoundEvent)SoundEvents.field_187716_o, (float)((float)APConfig.theUltimateArmorToughnessPoints));

    public BaseUltimateArmor(EntityEquipmentSlot slot) {
        super(theUltimateArmor, 0, slot);
        this.func_77625_d(1);
        switch (slot) {
            case FEET: {
                String boots = "the_ultimate_boots_full";
                this.setRegistryName(boots);
                this.func_77655_b(Utils.setName(boots));
                break;
            }
            case LEGS: {
                String leggings = "the_ultimate_leggings_full";
                this.setRegistryName(leggings);
                this.func_77655_b(Utils.setName(leggings));
                break;
            }
            case CHEST: {
                String chestplate = "the_ultimate_chestplate_full";
                this.setRegistryName(chestplate);
                this.func_77655_b(Utils.setName(chestplate));
                break;
            }
            case HEAD: {
                String helmet = "the_ultimate_helmet_full";
                this.setRegistryName(helmet);
                this.func_77655_b(Utils.setName(helmet));
            }
        }
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77637_a(ArmorPlus.tabArmorplus);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add("\u00a79Ability: \u00a7rThe Most OverPowered Armor");
            tooltip.add("\u00a73Use: \u00a7rEquip The Full Set");
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.shift.showinfo", (Object[])new Object[]{TextFormatting.func_96300_b((String)APConfig.theUltimateArmorItemNameColor), keyBindSneak.getDisplayName(), TextFormatting.GRAY, TextFormatting.GREEN}));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (APConfig.makeTheUltimateArmorUnbreakable) {
            Utils.setUnbreakable(stack);
        }
    }

    public void onArmorTick(World world, EntityPlayer entity, ItemStack itemStack) {
        ItemStack head = entity.func_184582_a(EntityEquipmentSlot.HEAD);
        ItemStack chest = entity.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack legs = entity.func_184582_a(EntityEquipmentSlot.LEGS);
        ItemStack feet = entity.func_184582_a(EntityEquipmentSlot.FEET);
        if (APConfig.enableFlightAbility) {
            if (head != null && head.func_77973_b() == ModItems.theUltimateHelmet && chest != null && chest.func_77973_b() == ModItems.theUltimateChestplate && legs != null && legs.func_77973_b() == ModItems.theUltimateLeggings && feet != null && feet.func_77973_b() == ModItems.theUltimateBoots || entity.field_71075_bZ.field_75098_d || entity.func_175149_v()) {
                entity.field_71075_bZ.field_75101_c = true;
            } else {
                entity.field_71075_bZ.field_75100_b = false;
                entity.field_71075_bZ.field_75101_c = false;
            }
        }
        if (APConfig.enableTheUltimateArmorInvincibility) {
            entity.field_71075_bZ.field_75102_a = head != null && head.func_77973_b() == ModItems.theUltimateHelmet && chest != null && chest.func_77973_b() == ModItems.theUltimateChestplate && legs != null && legs.func_77973_b() == ModItems.theUltimateLeggings && feet != null && feet.func_77973_b() == ModItems.theUltimateBoots || entity.field_71075_bZ.field_75098_d || entity.func_175149_v();
        }
        if (!(head != null && head.func_77973_b() == ModItems.theUltimateHelmet && chest != null && chest.func_77973_b() == ModItems.theUltimateChestplate && legs != null && legs.func_77973_b() == ModItems.theUltimateLeggings && feet != null && feet.func_77973_b() == ModItems.theUltimateBoots || entity.field_71075_bZ.field_75098_d || entity.func_175149_v() || !APConfig.enableTheUltimateArmorDeBuffs)) {
            PotionUtils.addEffect((EntityLivingBase)entity, MobEffects.field_76436_u, 60, 2, PotionUtils.EffectType.BAD);
            PotionUtils.addEffect((EntityLivingBase)entity, MobEffects.field_76421_d, 60, 2, PotionUtils.EffectType.BAD);
            PotionUtils.addEffect((EntityLivingBase)entity, MobEffects.field_76440_q, 60, 0, PotionUtils.EffectType.BAD);
            entity.field_70159_w = 0.0;
            if (entity.field_70122_E) {
                entity.field_70181_x = 0.0;
            }
            entity.field_70179_y = 0.0;
            entity.field_70133_I = true;
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (TextFormatting.func_96300_b((String)APConfig.theUltimateArmorItemNameColor) + TextHelper.localize((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(toRepair, (Item)ModItems.theUltimateMaterial, (Item)ModItems.theUltimateMaterial);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

