/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.compat.minetweaker;

import com.blamejared.mtlib.helpers.InputHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.thedragonteam.armorplus.api.crafting.workbench.ShapedOreRecipe;
import net.thedragonteam.armorplus.api.crafting.workbench.ShapelessOreRecipe;
import net.thedragonteam.armorplus.api.crafting.workbench.WorkbenchCraftingManager;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.armorplus.Workbench")
public class Workbench {
    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new ShapelessOreRecipe(InputHelper.toStack((IItemStack)output), InputHelper.toObjects((IIngredient[])ingredients))));
    }

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new ShapedOreRecipe(InputHelper.toStack((IItemStack)output), InputHelper.toShapedObjects((IIngredient[][])ingredients))));
    }

    @ZenMethod
    public static void remove(IItemStack target) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(InputHelper.toStack((IItemStack)target)));
    }

    private static class Remove
    implements IUndoableAction {
        IRecipe recipe = null;
        ItemStack remove;

        public Remove(ItemStack rem) {
            this.remove = rem;
        }

        public void apply() {
            for (IRecipe obj : WorkbenchCraftingManager.getInstance().getRecipeList()) {
                IRecipe craft;
                if (!(obj instanceof IRecipe) || !(craft = obj).func_77571_b().func_77969_a(this.remove)) continue;
                this.recipe = craft;
                MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
                WorkbenchCraftingManager.getInstance().getRecipeList().remove(obj);
                break;
            }
        }

        public boolean canUndo() {
            return this.recipe != null;
        }

        public void undo() {
            WorkbenchCraftingManager.getInstance().getRecipeList().add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Removing Workbench Recipe for " + this.remove.func_82833_r();
        }

        public String describeUndo() {
            return "Un-removing Workbench Recipe for " + this.remove.func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        IRecipe recipe;

        public Add(IRecipe add) {
            this.recipe = add;
        }

        public void apply() {
            WorkbenchCraftingManager.getInstance().getRecipeList().add(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            WorkbenchCraftingManager.getInstance().getRecipeList().remove(this.recipe);
            MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)this.recipe);
        }

        public String describe() {
            return "Adding Workbench Recipe for " + this.recipe.func_77571_b().func_82833_r();
        }

        public String describeUndo() {
            return "Un-adding Workbench for " + this.recipe.func_77571_b().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

