/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.base;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.items.BattleAxes;
import net.thedragonteam.armorplus.util.ArmorPlusItemUtils;
import net.thedragonteam.armorplus.util.PotionUtils;
import net.thedragonteam.armorplus.util.Utils;
import net.thedragonteam.thedragonlib.util.TextHelper;

public class BaseBattleAxe
extends ItemSword {
    public static Item.ToolMaterial battleAxeCoalMaterial = EnumHelper.addToolMaterial((String)"battleAxeCoalMaterial", (int)1, (int)APConfig.coalBattleAxeDurability, (float)1.0f, (float)((float)APConfig.coalBattleAxeDamage), (int)15);
    public static Item.ToolMaterial battleAxeLapisMaterial = EnumHelper.addToolMaterial((String)"battleAxeLapisMaterial", (int)1, (int)APConfig.lapisBattleAxeDurability, (float)1.0f, (float)((float)APConfig.lapisBattleAxeDamage), (int)30);
    public static Item.ToolMaterial battleAxeRedstoneMaterial = EnumHelper.addToolMaterial((String)"battleAxeRedstoneMaterial", (int)1, (int)APConfig.redstoneBattleAxeDurability, (float)1.0f, (float)((float)APConfig.redstoneBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeEmeraldMaterial = EnumHelper.addToolMaterial((String)"battleAxeEmeraldMaterial", (int)1, (int)APConfig.emeraldBattleAxeDurability, (float)1.0f, (float)((float)APConfig.emeraldBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeObsidianMaterial = EnumHelper.addToolMaterial((String)"battleAxeObsidianMaterial", (int)1, (int)APConfig.obsidianBattleAxeDurability, (float)1.0f, (float)((float)APConfig.obsidianBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeLavaMaterial = EnumHelper.addToolMaterial((String)"battleAxeLavaMaterial", (int)1, (int)APConfig.lavaBattleAxeDurability, (float)1.0f, (float)((float)APConfig.lavaBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeGuardianMaterial = EnumHelper.addToolMaterial((String)"battleAxeGuardianMaterial", (int)1, (int)APConfig.guardianBattleAxeDurability, (float)1.0f, (float)((float)APConfig.guardianBattleAxeDamage), (int)30);
    public static Item.ToolMaterial battleAxeSuperStarMaterial = EnumHelper.addToolMaterial((String)"battleAxeSuperStarMaterial", (int)1, (int)APConfig.superStarBattleAxeDurability, (float)1.0f, (float)((float)APConfig.superStarBattleAxeDamage), (int)20);
    public static Item.ToolMaterial battleAxeEnderDragonMaterial = EnumHelper.addToolMaterial((String)"battleAxeEnderDragonMaterial", (int)1, (int)APConfig.enderDragonBattleAxeDurability, (float)1.0f, (float)((float)APConfig.enderDragonBattleAxeDamage), (int)20);
    public Item itemEasy;
    public Item itemExpert;
    public TextFormatting formatting;
    public String effect;
    public BattleAxes battleAxes;
    public float efficiency;

    public BaseBattleAxe(BattleAxes battleAxes) {
        super(battleAxes.getToolMaterial());
        this.battleAxes = battleAxes;
        this.itemEasy = battleAxes.getRepairEasy();
        this.itemExpert = battleAxes.getRepairExpert();
        this.formatting = battleAxes.getTextFormatting();
        this.effect = battleAxes.getEffect();
        this.efficiency = battleAxes.getEfficiency();
        this.setRegistryName(battleAxes.func_176610_l());
        this.func_77655_b(Utils.setName(battleAxes.func_176610_l()));
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77637_a(ArmorPlus.tabArmorplusWeapons);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) : this.battleAxes.getEfficiency();
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        switch (this.battleAxes) {
            case COAL: {
                if (!APConfig.enableCoalWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.coalWeaponsAddPotionEffect), 180, APConfig.coalWeaponsEffectLevel, PotionUtils.EffectType.BAD);
                break;
            }
            case LAPIS: {
                if (!APConfig.enableLapisWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.lapisWeaponsAddPotionEffect), APConfig.lapisWeaponsEffectLevel, PotionUtils.EffectType.BAD);
                break;
            }
            case REDSTONE: {
                if (!APConfig.enableRedstoneWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.redstoneWeaponsAddPotionEffect), 180, APConfig.redstoneWeaponsEffectLevel, PotionUtils.EffectType.BAD);
                break;
            }
            case EMERALD: {
                if (!APConfig.enableEmeraldWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.emeraldWeaponsAddPotionEffect), APConfig.emeraldWeaponsEffectLevel, PotionUtils.EffectType.BAD);
                break;
            }
            case OBSIDIAN: {
                if (!APConfig.enableObsidianWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.obsidianWeaponsAddPotionEffect), APConfig.obsidianWeaponsEffectLevel, PotionUtils.EffectType.BAD);
                break;
            }
            case LAVA: {
                target.func_70015_d(8);
                break;
            }
            case GUARDIAN: {
                if (!APConfig.enableGuardianWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.guardianWeaponsAddPotionEffect), APConfig.guardianWeaponsEffectLevel, PotionUtils.EffectType.BAD);
                break;
            }
            case SUPER_STAR: {
                if (!APConfig.enableSuperStarWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.superStarWeaponsAddPotionEffect), APConfig.superStarWeaponsEffectLevel, PotionUtils.EffectType.BAD);
                break;
            }
            case ENDER_DRAGON: {
                if (!APConfig.enableEnderDragonWeaponsEffects) break;
                PotionUtils.addEffect(target, PotionUtils.getPotion(APConfig.enderDragonWeaponsAddPotionEffect), 60, APConfig.enderDragonWeaponsEffectLevel, PotionUtils.EffectType.BAD);
            }
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add("\u00a79Ability: \u00a7rApplies " + this.effect);
            tooltip.add("\u00a73Use: \u00a7rHit a Target");
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.tesla.showinfo", (Object[])new Object[]{this.formatting, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return (this.formatting + TextHelper.localize((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ArmorPlusItemUtils.isItemRepairable(toRepair, this.itemEasy, this.itemExpert);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

