/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.baubles;

import baubles.api.BaubleType;
import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.items.baubles.ItemBauble;
import net.thedragonteam.thedragonlib.util.TextHelper;

public class ItemBaubleDragon
extends ItemBauble
implements IEnergyContainerItem {
    private int storage = 1000;

    public ItemBaubleDragon() {
        super("bauble_cosmetic_dragon");
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.HEAD;
    }

    @Override
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    @Override
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return (TextFormatting.DARK_RED + TextHelper.localize((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[0])).trim();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    public int getMaxExtract(ItemStack container) {
        return 100;
    }

    public int getMaxReceive(ItemStack container) {
        return 100;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(this.getMaxReceive(container), maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.func_77978_p().func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.getMaxEnergyStored(container), maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy") ? 0 : container.func_77978_p().func_74762_e("Energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 10000;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"", (Object[])new Object[0]) + this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack) + I18n.func_135052_a((String)" RF", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.rf.showinfo", (Object[])new Object[]{TextFormatting.DARK_RED, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }
}

