/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.energy.rf;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.items.base.energy.rf.BaseRFHoe;

public class ItemRFHoe
extends BaseRFHoe {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc});

    public ItemRFHoe() {
        super(Item.ToolMaterial.DIAMOND, "redstone_flux_hoe", EFFECTIVE_ON, APConfig.maxCapacityHoe, APConfig.inputHoe, APConfig.outputHoe);
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77656_e(0);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        this.extractEnergy(stack, APConfig.outputHoe, false);
        return true;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.extractEnergy(stack, APConfig.outputHoe, false);
        return super.func_180614_a(stack, playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack powered = new ItemStack(itemIn, 1, 1);
        ItemStack unpowered = new ItemStack(itemIn);
        this.poweredItem(powered);
        subItems.add(powered);
        this.createPoweredStack(powered, false);
        subItems.add(unpowered);
    }

    private int poweredItem(ItemStack itemStack) {
        return this.receiveEnergy(itemStack, this.getMaxEnergyStored(itemStack), false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77952_i() == 1) {
            this.createPoweredStack(stack, false);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_150897_b(IBlockState state) {
        return Items.field_151012_L.func_150897_b(state);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.getEnergyStored(stack) < APConfig.outputHoe) {
            return 0.5f;
        }
        return Items.field_151017_I.func_150893_a(stack, state) > 1.0f ? 5.5f : super.func_150893_a(stack, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    private int createPoweredStack(ItemStack container, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b("Energy")) {
            return 0;
        }
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", APConfig.maxCapacityHoe);
        }
        return APConfig.maxCapacityHoe;
    }

    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"", (Object[])new Object[0]) + this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack) + I18n.func_135052_a((String)" RF", (Object[])new Object[0]));
            tooltip.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.rf.cost.tool", (Object[])new Object[]{Integer.toString(this.getMaxReceive(stack))}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.rf.showinfo", (Object[])new Object[]{TextFormatting.DARK_RED, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }
}

