/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.items.energy.tesla;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.ArmorPlus;
import net.thedragonteam.armorplus.items.base.energy.tesla.BaseTeslaPickaxe;
import net.thedragonteam.armorplus.util.APTeslaUtils;

public class ItemTeslaPickaxe
extends BaseTeslaPickaxe {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150408_cc, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150319_E, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150334_T, Blocks.field_150318_D, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150439_ay, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150333_U, Blocks.field_150430_aB, Blocks.field_150456_au});

    public ItemTeslaPickaxe() {
        super(Item.ToolMaterial.DIAMOND, "tesla_pickaxe", EFFECTIVE_ON, APConfig.maxCapacityPickaxe, APConfig.inputPickaxe, APConfig.outputPickaxe);
    }

    public CreativeTabs func_77640_w() {
        return ArmorPlus.tabArmorplusTesla;
    }

    @Optional.Method(modid="tesla")
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        APTeslaUtils.usePower(stack, APConfig.outputPickaxe);
        return true;
    }

    public boolean func_150897_b(IBlockState state) {
        return Items.field_151046_w.func_150897_b(state);
    }

    @Optional.Method(modid="tesla")
    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (APTeslaUtils.getStoredPower(stack) < (long)APConfig.outputPickaxe) {
            return 0.5f;
        }
        return Items.field_151039_o.func_150893_a(stack, state) > 1.0f ? 5.5f : super.func_150893_a(stack, state);
    }

    @Optional.Method(modid="tesla")
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.createTooltip(stack, tooltip);
    }

    @Optional.Method(modid="tesla")
    private void createTooltip(ItemStack stack, List<String> tooltip) {
        KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        if (GameSettings.func_100015_a((KeyBinding)keyBindSneak)) {
            tooltip.add(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"tooltip.tesla.powerinfo", (Object[])new Object[]{Long.toString(APTeslaUtils.getStoredPower(stack)), Long.toString(APTeslaUtils.getMaxCapacity(stack))}));
            tooltip.add(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"tooltip.tesla.cost.tool", (Object[])new Object[]{Long.toString(APConfig.outputPickaxe)}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.tesla.showinfo", (Object[])new Object[]{TextFormatting.DARK_AQUA, keyBindSneak.getDisplayName(), TextFormatting.GRAY}));
        }
    }
}

