/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.proxy;

import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.thedragonteam.armorplus.client.gui.APTab;
import net.thedragonteam.armorplus.commands.CommandArmorPlus;
import net.thedragonteam.armorplus.compat.ICompatibility;
import net.thedragonteam.armorplus.registry.MobDrops;
import net.thedragonteam.armorplus.registry.ModAchievements;
import net.thedragonteam.armorplus.registry.ModBlocks;
import net.thedragonteam.armorplus.registry.ModCompatibility;
import net.thedragonteam.armorplus.registry.ModEnchantments;
import net.thedragonteam.armorplus.registry.ModEntities;
import net.thedragonteam.armorplus.registry.ModItems;
import net.thedragonteam.armorplus.registry.ModOreDicts;
import net.thedragonteam.armorplus.registry.ModRecipes;
import net.thedragonteam.armorplus.resources.GlobalEventsArmorPlus;
import net.thedragonteam.armorplus.tileentity.TileEntityHighTechBench;
import net.thedragonteam.armorplus.tileentity.TileEntityUltiTechBench;
import net.thedragonteam.armorplus.tileentity.TileEntityWorkbench;
import net.thedragonteam.armorplus.util.Logger;
import net.thedragonteam.armorplus.worldgen.OreGen;
import net.thedragonteam.armorplus.worldgen.StructureGen;
import net.thedragonteam.thedragonlib.util.LogHelper;

public class CommonProxy {
    public static File configDir;

    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getModConfigurationDirectory() + "/" + "armorplus");
        configDir.mkdirs();
        Logger.init(new File(event.getModConfigurationDirectory().getPath()));
        ModEntities.init();
        ModBlocks.init();
        LogHelper.debug((Object)"Blocks Successfully Registered");
        ModItems.init();
        LogHelper.debug((Object)"Items Successfully Registered");
        this.registerWorldGenerators();
        this.registerTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new MobDrops());
        ModCompatibility.registerModCompat();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.PRE_INIT);
        LogHelper.info((Object)"Finished PreInitialization");
    }

    public void init(FMLInitializationEvent event) {
        this.registerEvents();
        ModOreDicts.registerOreDictEntries();
        APTab.initialize();
        ModEnchantments.registerEnchantments();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.INIT);
        LogHelper.info((Object)"Finished Initialization");
    }

    public void postInit(FMLPostInitializationEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.POST_INIT);
        LogHelper.info((Object)"Finished PostInitialization");
    }

    public void modMapping(FMLModIdMappingEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.MAPPING);
    }

    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandArmorPlus());
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new GlobalEventsArmorPlus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModAchievements.init();
        ModRecipes.init();
    }

    public void registerModels() {
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntityWithAlternatives(TileEntityWorkbench.class, (String)"Workbench", (String[])new String[]{"ARPWorkbench", "WorkbenchTier1", "WorkbenchTierOne"});
        GameRegistry.registerTileEntityWithAlternatives(TileEntityHighTechBench.class, (String)"HighTechBench", (String[])new String[]{"ARPHighTechBench", "WorkbenchTier2", "WorkbenchTierTwo"});
        GameRegistry.registerTileEntityWithAlternatives(TileEntityUltiTechBench.class, (String)"UltiTechBench", (String[])new String[]{"ARPHighTechBench", "WorkbenchTier3", "WorkbenchTierThree"});
    }

    public void registerWorldGenerators() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGen(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StructureGen(), (int)1);
    }
}

