/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.armorplus.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.thedragonteam.armorplus.APConfig;
import net.thedragonteam.armorplus.worldgen.structures.StructureCastle;

public class StructureGen
implements IWorldGenerator {
    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150346_d || blockAt == Blocks.field_150349_c || blockAt != Blocks.field_150350_a;
        }
        return y;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateOverworldStructures(world, random, blockX, blockZ);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void generateOverworldStructures(World world, Random rand, int blockX, int blockZ) {
        if (APConfig.enableCastleGen) {
            StructureCastle genCastle = new StructureCastle();
            if (rand.nextInt(1000) < APConfig.castleGenSpawnChance) {
                int randX = blockX + rand.nextInt(16);
                int randZ = blockZ + rand.nextInt(16);
                int groundY = StructureGen.getGroundFromAbove(world, randX, randZ);
                genCastle.func_180709_b(world, rand, new BlockPos(randX, groundY + 1, randZ));
            }
        }
    }
}

