/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.thedragonlib.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.sofodev.thedragonlib.util.LogHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GLStateHelper {
    private static int lastBlendState = -1;
    private static int lastAlphaState = -1;
    private static int lastDepthState = -1;

    public static void pushBlend(boolean enable) {
        if (lastBlendState != -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to push twice", new Object[0]);
        } else {
            lastBlendState = GlStateManager.func_227612_D_((int)3042);
            if (enable) {
                GlStateManager.func_227740_m_();
            } else {
                GlStateManager.func_227737_l_();
            }
        }
    }

    public static void popBlend() {
        switch (lastBlendState) {
            case -1: {
                LogHelper.bigError("[GLStateHelper] Attempt to pop before pushing", new Object[0]);
                break;
            }
            default: {
                if (lastBlendState == 1) {
                    GlStateManager.func_227740_m_();
                } else {
                    GlStateManager.func_227737_l_();
                }
                lastBlendState = -1;
            }
        }
    }

    public static void pushAlpha(boolean enable) {
        if (lastAlphaState != -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to push twice", new Object[0]);
        } else {
            lastAlphaState = GlStateManager.func_227612_D_((int)6406);
            if (enable) {
                GlStateManager.func_227709_e_();
            } else {
                GlStateManager.func_227700_d_();
            }
        }
    }

    public static void popAlpha() {
        if (lastAlphaState == -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to pop before pushing", new Object[0]);
        } else {
            if (lastAlphaState == 1) {
                GlStateManager.func_227709_e_();
            } else {
                GlStateManager.func_227700_d_();
            }
            lastAlphaState = -1;
        }
    }

    public static void pushDepth(boolean enable) {
        if (lastDepthState != -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to push twice", new Object[0]);
        } else {
            lastDepthState = GlStateManager.func_227612_D_((int)6145);
            if (enable) {
                GlStateManager.func_227709_e_();
            } else {
                GlStateManager.func_227700_d_();
            }
        }
    }

    public static void popDepth() {
        if (lastDepthState == -1) {
            LogHelper.bigError("[GLStateHelper] Attempt to pop before pushing", new Object[0]);
        } else {
            if (lastDepthState == 1) {
                GlStateManager.func_227709_e_();
            } else {
                GlStateManager.func_227700_d_();
            }
            lastDepthState = -1;
        }
    }
}

