/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.thedragonlib.util;

import com.sofodev.thedragonlib.lib.Vec3D;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class Utils {
    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (value < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    public static String formatNumber(long value) {
        if (value < 1000L) {
            return String.valueOf(value);
        }
        if (value < 1000000L) {
            return String.valueOf((double)value / 1000.0) + "K";
        }
        if (value < 1000000000L) {
            return String.valueOf((double)value / 1000.0 / 1000.0) + "M";
        }
        if (value < 1000000000000L) {
            return String.valueOf((double)value / 1000000.0 / 1000.0) + "B";
        }
        if (value < 1000000000000000L) {
            return String.valueOf((double)value / 1.0E9 / 1000.0) + "T";
        }
        if (value < 1000000000000000000L) {
            return String.valueOf((double)value / 1.0E12 / 1000.0) + "Quad";
        }
        return String.valueOf((double)value / 1.0E15 / 1000.0) + "Quin";
    }

    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistanceAtoB(Vec3D pos1, Vec3D pos2) {
        return Utils.getDistanceAtoB(pos1.x, pos1.y, pos1.z, pos2.x, pos2.y, pos2.z);
    }

    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static double getDistanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static double getDistanceSq(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return dx * dx + dz * dz;
    }

    public static void updateNeabourBlocks(World world, BlockPos pos) {
    }

    public static int determineOrientation(int x, int y, int z, LivingEntity entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.func_226277_ct_() - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.func_226281_cx_() - (float)z)) < 2.0f) {
            double d0 = entity.func_226278_cu_() + 1.82 - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return 0;
            }
            if ((double)y - d0 > 0.0) {
                return 1;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 3 : (l == 1 ? 4 : (l == 2 ? 2 : 5));
    }

    public static double round(double number, double multiplier) {
        return (double)Math.round(number * multiplier) / multiplier;
    }

    public static int getNearestMultiple(int number, int multiple) {
        int result = number;
        if (number < 0) {
            result *= -1;
        }
        if (result % multiple == 0) {
            return number;
        }
        result = result % multiple < multiple / 2 ? (result -= result % multiple) : (result += multiple - result % multiple);
        if (number < 0) {
            result *= -1;
        }
        return result;
    }

    public static int toInt(double d) {
        return (int)d;
    }

    public static ResourceLocation toRL(String registryName) {
        return new ResourceLocation(registryName);
    }

    public static ResourceLocation toRL(String modid, String name) {
        return new ResourceLocation(modid, name);
    }
}

