/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus;

import com.sofodev.armorplus.registry.APItems;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.ModEntities;
import com.sofodev.armorplus.registry.blocks.castle.BrickColor;
import com.sofodev.armorplus.registry.entities.arrows.APArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.CoalArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.EmeraldArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.EnderDragonArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.GuardianArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.InfusedLavaArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.LapisArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.ObsidianArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.RedstoneArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.SuperStarArrowEntity;
import com.sofodev.armorplus.registry.entities.bosses.SkeletalKingRenderer;
import com.sofodev.armorplus.registry.entities.bosses.WitherMinionRenderer;
import com.sofodev.armorplus.registry.entities.bosses.WitherlingRenderer;
import com.sofodev.armorplus.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.registry.items.tools.properties.APToolProperties;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="armorplus")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="armorplus")
public class ArmorPlus {
    public static final String MODID = "armorplus";
    public static final String MODNAME = "ArmorPlus";
    public static final String VERSION = "1.16.3-16.0.0.1";
    private static ArmorPlus instance;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Enchantment> ENCHANTMENTS;
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES;
    public static final DeferredRegister<EntityType<?>> ENTITIES;
    public static final DeferredRegister<Effect> EFFECTS;
    public static final int AP_ARMOR_MATERIAL_LENGTH;
    public static final int AP_TOOL_MATERIAL_LENGTH;
    public static final int AP_STONE_BRICKS_LENGTH;
    public static final ItemGroup AP_GROUP;
    public static final ItemGroup AP_ITEM_GROUP;
    public static final ItemGroup AP_BLOCK_GROUP;
    public static final ItemGroup AP_WEAPON_GROUP;

    public ArmorPlus() {
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENCHANTMENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientInit(FMLClientSetupEvent event) {
        ArmorPlus.registerRenderingHandler(CoalArrowEntity.class, "coal");
        ArmorPlus.registerRenderingHandler(LapisArrowEntity.class, "lapis");
        ArmorPlus.registerRenderingHandler(RedstoneArrowEntity.class, "redstone");
        ArmorPlus.registerRenderingHandler(EmeraldArrowEntity.class, "emerald");
        ArmorPlus.registerRenderingHandler(ObsidianArrowEntity.class, "obsidian");
        ArmorPlus.registerRenderingHandler(InfusedLavaArrowEntity.class, "lava");
        ArmorPlus.registerRenderingHandler(GuardianArrowEntity.class, "guardian");
        ArmorPlus.registerRenderingHandler(SuperStarArrowEntity.class, "super_star");
        ArmorPlus.registerRenderingHandler(EnderDragonArrowEntity.class, "ender_dragon");
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.SKELETAL_KING.get()), SkeletalKingRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.WITHER_MINION.get()), WitherMinionRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.WITHERLING.get()), WitherlingRenderer::new);
        this.setRenderLayer(ModBlocks.LAVA_INFUSER);
    }

    @SafeVarargs
    private final void setRenderLayer(RegistryObject<Block> ... blocks) {
        Arrays.stream(blocks).forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
    }

    private static void registerRenderingHandler(Class<? extends APArrowEntity> entityClass, String name) {
    }

    public static ArmorPlus getInstance() {
        return instance;
    }

    static {
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)MODID);
        TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)MODID);
        ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)MODID);
        EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)MODID);
        AP_ARMOR_MATERIAL_LENGTH = APArmorMaterial.values().length;
        AP_TOOL_MATERIAL_LENGTH = APToolProperties.values().length;
        AP_STONE_BRICKS_LENGTH = BrickColor.values().length;
        AP_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("armors")){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)Utils.getAPItem("infused_lava_chestplate"));
            }
        };
        AP_ITEM_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("items")){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)APItems.INFUSED_LAVA_CRYSTAL.get());
            }
        };
        AP_BLOCK_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("blocks")){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.LAVA_CRYSTAL.get());
            }
        };
        AP_WEAPON_GROUP = new ItemGroup(ItemGroup.getGroupCountSafe(), Utils.setName("weapons")){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)Utils.getAPItem("ender_dragon_battle_axe"));
            }
        };
    }
}

