/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.blocks.APFrostBlock;
import com.sofodev.armorplus.registry.blocks.APLavaBlock;
import com.sofodev.armorplus.registry.blocks.castle.BrickColor;
import com.sofodev.armorplus.registry.blocks.castle.CastleBlock;
import com.sofodev.armorplus.registry.blocks.castle.StoneBrickBlock;
import com.sofodev.armorplus.registry.blocks.castle.StoneBrickCornerBlock;
import com.sofodev.armorplus.registry.blocks.castle.StoneBrickTowerBlock;
import com.sofodev.armorplus.registry.blocks.castle.StoneBrickWallBlock;
import com.sofodev.armorplus.registry.blocks.crafting.LavaInfuserBlock;
import com.sofodev.armorplus.registry.blocks.crafting.LavaInfuserTile;
import com.sofodev.armorplus.registry.blocks.ore.CrystalOreBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="armorplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static List<RegistryObject<Block>> blocks = new ArrayList<RegistryObject<Block>>();
    public static final RegistryObject<Block> COMPRESSED_OBSIDIAN = ModBlocks.regWithItem("compressed_obsidian", () -> new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150343_Z)));
    public static final RegistryObject<Block> ORE_LAVA_CRYSTAL = ModBlocks.regWithItem("ore_lava_crystal", CrystalOreBlock::new);
    public static final RegistryObject<Block> LAVA_CRYSTAL = ModBlocks.regWithItem("block_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> INFUSED_LAVA_CRYSTAL = ModBlocks.regWithItem("block_infused_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> COMPRESSED_LAVA_CRYSTAL = ModBlocks.regWithItem("compressed_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> COMPRESSED_INFUSED_LAVA_CRYSTAL = ModBlocks.regWithItem("compressed_infused_lava_crystal", APLavaBlock::new);
    public static final RegistryObject<Block> LAVA_INFUSED_OBSIDIAN = ModBlocks.regWithItem("lava_infused_obsidian", () -> new APLavaBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151678_z).func_200948_a(25.0f, 2000.0f)));
    public static final RegistryObject<Block> ORE_FROST_CRYSTAL = ModBlocks.regWithItem("ore_frost_crystal", CrystalOreBlock::new);
    public static final RegistryObject<Block> FROST_CRYSTAL = ModBlocks.regWithItem("block_frost_crystal", APFrostBlock::new);
    public static final RegistryObject<Block> INFUSED_FROST_CRYSTAL = ModBlocks.regWithItem("block_infused_frost_crystal", APFrostBlock::new);
    public static final RegistryObject<Block>[] STONE_BRICKS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_TOWERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_CORNERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] STONE_BRICK_WALLS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCKS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_TOWERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_CORNERS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block>[] CASTLE_BLOCK_WALLS = new RegistryObject[ArmorPlus.AP_STONE_BRICKS_LENGTH];
    public static final RegistryObject<Block> LAVA_INFUSER = ModBlocks.regWithItem("lava_infuser", LavaInfuserBlock::new);
    public static final RegistryObject<TileEntityType<LavaInfuserTile>> LAVA_INFUSER_TYPE = ArmorPlus.TILE_ENTITIES.register("lava_infuser", () -> ModBlocks.build(TileEntityType.Builder.func_223042_a(LavaInfuserTile::new, (Block[])new Block[]{(Block)LAVA_INFUSER.get()})));

    public static RegistryObject<Block> register(String name, Supplier<? extends Block> sup) {
        return ArmorPlus.BLOCKS.register(name, sup);
    }

    public static RegistryObject<Block> regWithItem(String name, Supplier<? extends Block> sup) {
        RegistryObject<Block> block = ModBlocks.register(name, sup);
        blocks.add(block);
        return block;
    }

    private static <T extends TileEntity> TileEntityType<T> build(TileEntityType.Builder<T> builder) {
        return builder.func_206865_a(null);
    }

    public static void registerBlocks() {
        IntStream.range(0, ArmorPlus.AP_STONE_BRICKS_LENGTH).forEach(index -> {
            String color = BrickColor.values()[index].getName();
            ModBlocks.STONE_BRICKS[index] = ModBlocks.regWithItem(color + "_stone_brick", () -> new StoneBrickBlock(BrickColor.values()[index]));
            ModBlocks.STONE_BRICK_CORNERS[index] = ModBlocks.regWithItem(color + "_stone_brick_corner", () -> new StoneBrickCornerBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.STONE_BRICK_TOWERS[index] = ModBlocks.regWithItem(color + "_stone_brick_tower", () -> new StoneBrickTowerBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.STONE_BRICK_WALLS[index] = ModBlocks.regWithItem(color + "_stone_brick_wall", () -> new StoneBrickWallBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.CASTLE_BLOCKS[index] = ModBlocks.regWithItem(color + "_castle_block", () -> new CastleBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.CASTLE_BLOCK_CORNERS[index] = ModBlocks.regWithItem(color + "_castle_block_corner", () -> new StoneBrickCornerBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.CASTLE_BLOCK_TOWERS[index] = ModBlocks.regWithItem(color + "_castle_block_tower", () -> new StoneBrickTowerBlock((Block)STONE_BRICKS[index].get()));
            ModBlocks.CASTLE_BLOCK_WALLS[index] = ModBlocks.regWithItem(color + "_castle_block_wall", () -> new StoneBrickWallBlock((Block)STONE_BRICKS[index].get()));
        });
    }

    static {
        ModBlocks.registerBlocks();
    }
}

