/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.ModBlocks;
import com.sofodev.armorplus.registry.entities.arrows.ArrowType;
import com.sofodev.armorplus.registry.items.armors.APArmorItem;
import com.sofodev.armorplus.registry.items.armors.APArmorMaterial;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.arrows.APArrowItem;
import com.sofodev.armorplus.registry.items.tools.APBattleAxeItem;
import com.sofodev.armorplus.registry.items.tools.APPickaxeItem;
import com.sofodev.armorplus.registry.items.tools.APSwordItem;
import com.sofodev.armorplus.registry.items.tools.properties.APToolMaterial;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="armorplus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    public static final Set<RegistryObject<APArmorItem>> HELMETS = ModItems.registerArmorForSlot(EquipmentSlotType.HEAD);
    public static final Set<RegistryObject<APArmorItem>> CHESTPLATES = ModItems.registerArmorForSlot(EquipmentSlotType.CHEST);
    public static final Set<RegistryObject<APArmorItem>> LEGGINGS = ModItems.registerArmorForSlot(EquipmentSlotType.LEGS);
    public static final Set<RegistryObject<APArmorItem>> BOOTS = ModItems.registerArmorForSlot(EquipmentSlotType.FEET);
    public static final RegistryObject<Item>[] SWORDS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] BATTLE_AXES = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] PICKAXES = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<Item>[] SHOVELS = new RegistryObject[ArmorPlus.AP_TOOL_MATERIAL_LENGTH];
    public static final RegistryObject<ArrowItem> ITEM_COAL_ARROW = ModItems.registerArrow(ArrowType.COAL);
    public static final RegistryObject<ArrowItem> ITEM_LAPIS_ARROW = ModItems.registerArrow(ArrowType.LAPIS);
    public static final RegistryObject<ArrowItem> ITEM_REDSTONE_ARROW = ModItems.registerArrow(ArrowType.REDSTONE);
    public static final RegistryObject<ArrowItem> ITEM_EMERALD_ARROW = ModItems.registerArrow(ArrowType.EMERALD);
    public static final RegistryObject<ArrowItem> ITEM_OBSIDIAN_ARROW = ModItems.registerArrow(ArrowType.OBSIDIAN);
    public static final RegistryObject<ArrowItem> ITEM_INFUSED_LAVA_ARROW = ModItems.registerArrow(ArrowType.INFUSED_LAVA);
    public static final RegistryObject<ArrowItem> ITEM_GUARDIAN_ARROW = ModItems.registerArrow(ArrowType.GUARDIAN);
    public static final RegistryObject<ArrowItem> ITEM_SUPER_STAR_ARROW = ModItems.registerArrow(ArrowType.SUPER_STAR);
    public static final RegistryObject<ArrowItem> ITEM_ENDER_DRAGON_ARROW = ModItems.registerArrow(ArrowType.ENDER_DRAGON);
    public static final Set<RegistryObject<BlockItem>> ITEM_BLOCKS = ModItems.registerBlockItems();

    public static Set<RegistryObject<APArmorItem>> registerArmorForSlot(EquipmentSlotType slot) {
        return Arrays.stream(APArmorMaterial.values()).map(mat -> ArmorPlus.ITEMS.register(String.format("%s_%s", mat.getName(), Utils.getNormalizedName(slot)), () -> new APArmorItem((IAPArmor)mat, slot))).collect(Collectors.toSet());
    }

    public static void registerToolForType(RegistryObject<Item>[] swords, RegistryObject<Item>[] axes, RegistryObject<Item>[] pickaxes, RegistryObject<Item>[] shovels) {
        IntStream.range(0, ArmorPlus.AP_TOOL_MATERIAL_LENGTH).forEach(i -> {
            APToolMaterial mat = APToolMaterial.values()[i];
            swords[i] = ArmorPlus.ITEMS.register(String.format("%s_sword", mat.getName()), () -> new APSwordItem(mat));
            axes[i] = ArmorPlus.ITEMS.register(String.format("%s_battle_axe", mat.getName()), () -> new APBattleAxeItem(mat));
            pickaxes[i] = ArmorPlus.ITEMS.register(String.format("%s_pickaxe", mat.getName()), () -> new APPickaxeItem(mat));
        });
    }

    public static Set<RegistryObject<BlockItem>> registerBlockItems() {
        return ModBlocks.blocks.stream().map(block -> ArmorPlus.ITEMS.register(block.getId().func_110623_a(), () -> new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(ArmorPlus.AP_BLOCK_GROUP)))).collect(Collectors.toSet());
    }

    public static RegistryObject<ArrowItem> registerArrow(ArrowType type) {
        return ArmorPlus.ITEMS.register(type.getItemArrowName(), () -> new APArrowItem(type));
    }

    static {
        ModItems.registerToolForType(SWORDS, BATTLE_AXES, PICKAXES, SHOVELS);
    }
}

