/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.enchantments;

import com.sofodev.armorplus.registry.enchantments.APEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;

public class LifeStealEnchantment
extends APEnchantment {
    public LifeStealEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentType.WEAPON, new EquipmentSlotType[]{EquipmentSlotType.MAINHAND}, 1, 3, 10, 30, true, true);
    }

    public void func_151367_b(LivingEntity user, Entity attacker, int level) {
        if (level > Levels.limit()) {
            level = Levels.limit();
        }
        super.func_151367_b(user, attacker, level);
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        if (level > Levels.limit()) {
            level = Levels.limit();
        }
        Levels lvl = Levels.values()[level];
        if (user == null || target == null) {
            return;
        }
        ItemStack mainHand = user.func_184614_ca();
        Item handItem = mainHand.func_77973_b();
        if (mainHand.func_190926_b()) {
            return;
        }
        if (!this.isCorrectItem(handItem)) {
            user.func_70691_i(lvl.healingFactor);
        } else if (handItem instanceof ToolItem) {
            float damageDealt = ((ToolItem)handItem).func_200891_e().func_200929_c();
            user.func_70691_i((float)level * this.softCap(damageDealt, 10.0f, 1.0f) / 4.0f);
        } else if (handItem instanceof SwordItem) {
            float damageDealt = ((SwordItem)handItem).func_200894_d();
            user.func_70691_i((float)level * this.softCap(damageDealt, 10.0f, 1.0f) / 4.0f);
        }
    }

    private float softCap(float value, float max, float scale) {
        if (value <= max) {
            return value;
        }
        float space = max * scale;
        float offset = value - max;
        return max + space * offset / (space + offset);
    }

    private boolean isCorrectItem(Item item) {
        return item instanceof SwordItem || item instanceof ToolItem;
    }

    public static enum Levels {
        ZERO(0.0f),
        ONE(0.5f),
        TWO(1.5f),
        THREE(2.5f);

        public final float healingFactor;

        private Levels(float healingFactor) {
            this.healingFactor = healingFactor;
        }

        public static int limit() {
            return Levels.values().length - 1;
        }
    }
}

