/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.arrows;

import com.sofodev.armorplus.registry.entities.arrows.APArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.CoalArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.EmeraldArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.EnderDragonArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.GuardianArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.InfusedLavaArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.LapisArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.ObsidianArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.RedstoneArrowEntity;
import com.sofodev.armorplus.registry.entities.arrows.impl.SuperStarArrowEntity;
import com.sofodev.armorplus.utils.ToolTipUtils;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ArrowType {
    public static final ArrowType COAL = new ArrowType("coal", 3.0, TextFormatting.GRAY){

        @Override
        public APArrowEntity createArrow(LivingEntity shooter, World world) {
            return new CoalArrowEntity(shooter, world);
        }
    };
    public static final ArrowType LAPIS = new ArrowType("lapis", 3.5, TextFormatting.DARK_AQUA){

        @Override
        public APArrowEntity createArrow(LivingEntity shooter, World world) {
            return new LapisArrowEntity(shooter, world);
        }
    };
    public static final ArrowType REDSTONE = new ArrowType("redstone", 3.5, TextFormatting.DARK_RED){

        @Override
        public APArrowEntity createArrow(LivingEntity shooter, World world) {
            return new RedstoneArrowEntity(shooter, world);
        }
    };
    public static final ArrowType EMERALD = new ArrowType("emerald", 5.0, TextFormatting.DARK_GREEN){

        @Override
        public APArrowEntity createArrow(LivingEntity shooter, World world) {
            return new EmeraldArrowEntity(shooter, world);
        }
    };
    public static final ArrowType OBSIDIAN = new ArrowType("obsidian", 6.0, TextFormatting.DARK_GRAY){

        @Override
        public AbstractArrowEntity createArrow(LivingEntity shooter, World world) {
            return new ObsidianArrowEntity(shooter, world);
        }
    };
    public static final ArrowType INFUSED_LAVA = new ArrowType("infused_lava", 10.5, TextFormatting.GOLD){

        @Override
        public AbstractArrowEntity createArrow(LivingEntity shooter, World world) {
            return new InfusedLavaArrowEntity(shooter, world);
        }
    };
    public static final ArrowType GUARDIAN = new ArrowType("guardian", 10.5, TextFormatting.AQUA){

        @Override
        public AbstractArrowEntity createArrow(LivingEntity shooter, World world) {
            return new GuardianArrowEntity(shooter, world);
        }
    };
    public static final ArrowType SUPER_STAR = new ArrowType("super_star", 10.5, TextFormatting.WHITE){

        @Override
        public AbstractArrowEntity createArrow(LivingEntity shooter, World world) {
            return new SuperStarArrowEntity(shooter, world);
        }
    };
    public static final ArrowType ENDER_DRAGON = new ArrowType("ender_dragon", 10.5, TextFormatting.DARK_PURPLE){

        @Override
        public AbstractArrowEntity createArrow(LivingEntity shooter, World world) {
            return new EnderDragonArrowEntity(shooter, world);
        }
    };
    private final String txt;
    private final double dmg;
    private final TextFormatting formatting;

    ArrowType(String txt, double dmg, TextFormatting formatting) {
        this.txt = txt;
        this.dmg = dmg;
        this.formatting = formatting;
    }

    public String getTxt() {
        return this.txt;
    }

    public TranslationTextComponent getAbilityDescription() {
        return new TranslationTextComponent("item.armorplus." + this.getTxt() + "_arrow.ability_desc");
    }

    public TextFormatting getFormatting() {
        return this.formatting;
    }

    public double getDmg() {
        return this.dmg;
    }

    public String getName() {
        return this.txt;
    }

    public String getItemArrowName() {
        return this.getName() + "_arrow";
    }

    public AbstractArrowEntity createArrow(LivingEntity shooter, World world) {
        return new ArrowEntity(world, shooter);
    }

    public void addInformation(List<ITextComponent> tooltip) {
        ToolTipUtils.addArrowInformation(tooltip, (ITextComponent)this.getAbilityDescription(), this.getDmg(), this.getFormatting());
    }
}

