/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses;

import com.google.common.base.Predicate;
import com.sofodev.armorplus.registry.APItems;
import com.sofodev.armorplus.registry.entities.bosses.WitherMinionEntity;
import com.sofodev.armorplus.registry.entities.bosses.extras.SpecificRangedAttackGoal;
import com.sofodev.armorplus.registry.entities.bosses.extras.SpecificServerBossInfo;
import com.sofodev.armorplus.utils.ToolTipUtils;
import java.util.Collections;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class SkeletalKingEntity
extends WitherSkeletonEntity
implements IRangedAttackMob {
    public static final Predicate<Entity> ANY_ENTITY = entity -> entity instanceof LivingEntity && ((LivingEntity)entity).func_190631_cK() && !(entity instanceof SkeletalKingEntity);
    private final SpecificServerBossInfo bossInfo;
    private final EntityType<? extends SkeletalKingEntity> type;

    public SkeletalKingEntity(EntityType<? extends SkeletalKingEntity> type, World world) {
        super(type, world);
        this.type = type;
        this.bossInfo = new SpecificServerBossInfo(this.func_145748_c_(), SpecificServerBossInfo.BossInfoDungeonType.SKELETAL_KING);
        this.func_110163_bv();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(this.func_213311_cf() * 7.0f, this.func_213302_cg() * 7.0f, true);
    }

    public void func_70071_h_() {
        if (this.func_70644_a(Effects.field_82731_v)) {
            this.func_195063_d(Effects.field_82731_v);
        }
        if (!this.func_70644_a(Effects.field_76429_m)) {
            this.func_195064_c(new EffectInstance(Effects.field_76429_m, 240, 0));
        }
        super.func_70071_h_();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SpecificRangedAttackGoal(this, SpecificRangedAttackGoal.EntityAIType.WITHER));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, true, ANY_ENTITY));
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private void launchWitherMinionsToEntity(int pos, LivingEntity entity) {
        this.launchWitherMinions(pos, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e() * 0.5, entity.func_226281_cx_());
    }

    private void launchWitherMinions(int pos, double x, double y, double z) {
        this.field_70170_p.func_217378_a(null, 1024, new BlockPos((Vector3i)this.func_233580_cy_()), 0);
        double headingX = this.getHeadX(pos);
        double headingY = this.getHeadY(pos);
        double headingZ = this.getHeadZ(pos);
        double estimatedX = x - headingX;
        double estimatedY = y - headingY;
        double estimatedZ = z - headingZ;
        WitherMinionEntity witherMinion = new WitherMinionEntity(this.field_70170_p, (LivingEntity)this, estimatedX, estimatedY, estimatedZ);
        witherMinion.func_70634_a(headingX, headingY, headingZ);
        this.field_70170_p.func_217376_c((Entity)witherMinion);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.launchWitherMinionsToEntity(0, target);
    }

    private double getHeadX(int xPos) {
        if (xPos <= 0) {
            return this.func_226277_ct_();
        }
        float f = (this.field_70761_aq + (float)(180 * (xPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.func_226277_ct_() + (double)f1 * 1.3;
    }

    private double getHeadY(int yPos) {
        return yPos <= 0 ? this.func_226278_cu_() + 3.0 : this.func_226278_cu_() + 2.2;
    }

    private double getHeadZ(int zPos) {
        if (zPos <= 0) {
            return this.func_226281_cx_();
        }
        float f = (this.field_70761_aq + (float)(180 * (zPos - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.func_226281_cx_() + (double)f1 * 1.3;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            String[] names;
            for (String name : names = new String[]{"D", "E", "A", "T", "H"}) {
                BlazeEntity split = new BlazeEntity(EntityType.field_200792_f, this.field_70170_p);
                split.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                split.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Vector3i)this.func_233580_cy_())), SpawnReason.NATURAL, null, null);
                this.field_70170_p.func_217376_c((Entity)split);
                split.func_200203_b((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "" + TextFormatting.BOLD + name));
                split.func_174805_g(true);
                split.func_82142_c(false);
                split.func_184224_h(false);
                split.func_98053_h(true);
                split.field_98038_p = true;
            }
            this.func_70099_a(new ItemStack((IItemProvider)Items.field_151156_bN, 2 + this.field_70146_Z.nextInt(1)), 5.0f);
            this.func_70099_a(new ItemStack((IItemProvider)APItems.WITHER_BONE.get(), 1 + this.field_70146_Z.nextInt(1)), 5.0f);
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
    }

    private static String dialog(String part, Object ... args) {
        return "\n" + ToolTipUtils.translate("dialogs.armorplus.skeletal_king." + part, args).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.ITALIC));
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    public float func_70111_Y() {
        return super.func_70111_Y();
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public Iterable<ItemStack> func_184209_aF() {
        return Collections.emptyList();
    }

    public Iterable<ItemStack> func_184214_aD() {
        return Collections.emptyList();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(1024.0);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.6f);
        this.func_110148_a(Attributes.field_233826_i_).func_111128_a(8.0);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }
}

