/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.entities.bosses;

import com.sofodev.armorplus.registry.ModEntities;
import com.sofodev.armorplus.registry.entities.bosses.SkeletalKingEntity;
import com.sofodev.armorplus.registry.entities.bosses.WitherlingEntity;
import com.sofodev.armorplus.registry.entities.bosses.data.MinionType;
import com.sofodev.armorplus.utils.ToolTipUtils;
import com.sofodev.armorplus.utils.Utils;
import java.util.Arrays;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class WitherMinionEntity
extends FireballEntity {
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(WitherMinionEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private EntityType<? extends WitherMinionEntity> type;

    public WitherMinionEntity(EntityType<? extends WitherMinionEntity> type, World world) {
        super(type, world);
        this.type = type;
    }

    public WitherMinionEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(worldIn, shooter, accelX, accelY, accelZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public WitherMinionEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return new EntitySize(0.3125f, 0.3125f, true);
    }

    private static void setDropChance(WitherlingEntity minion, EquipmentSlotType ... slots) {
        Arrays.stream(slots).forEachOrdered(slot -> minion.func_184642_a((EquipmentSlotType)slot, 0.0f));
    }

    protected float func_82341_c() {
        return super.func_82341_c();
    }

    public boolean func_70027_ad() {
        return false;
    }

    protected void func_70227_a(RayTraceResult result) {
        int min;
        if (this.field_70170_p.field_72995_K || this.getEntity() == null || result.func_216346_c() != RayTraceResult.Type.ENTITY) {
            return;
        }
        BlockPos blockPos = new BlockPos(result.func_216347_e());
        String phaseText = "%sRise Minions, Rise!!!";
        int amountWarriorMax = 4;
        int amountArcherMax = 3;
        int amountPaladinMax = 2;
        int warriorBound = this.field_70146_Z.nextInt(amountWarriorMax) + 1;
        int archerBound = this.field_70146_Z.nextInt(amountArcherMax) + 1;
        int paladinBound = this.field_70146_Z.nextInt(amountPaladinMax) + 1;
        if (this.checkPhase(1200.0f, 0.0f)) {
            for (min = 0; min < warriorBound; ++min) {
                WitherlingEntity minionWarrior;
                if (this.checkPhase(1200.0f)) {
                    minionWarrior = this.create(blockPos);
                    this.setMinionStats(minionWarrior, MinionType.WARRIOR_0);
                    continue;
                }
                if (this.checkPhase(1000.0f)) {
                    minionWarrior = this.create(blockPos);
                    this.setMinionStats(minionWarrior, MinionType.WARRIOR_1);
                    continue;
                }
                minionWarrior = this.create(blockPos);
                this.spawnMinions(minionWarrior, MinionType.WARRIOR_2, MinionType.WARRIOR_3, MinionType.WARRIOR_4, MinionType.WARRIOR_5);
            }
        }
        if (this.checkPhase(800.0f, 0.0f)) {
            for (min = 0; min < archerBound; ++min) {
                WitherlingEntity minionArcher = this.create(blockPos);
                this.spawnMinions(minionArcher, MinionType.ARCHER_1, MinionType.ARCHER_2, MinionType.ARCHER_3, MinionType.ARCHER_4);
            }
        }
        if (this.checkPhase(400.0f, 0.0f)) {
            for (min = 0; min < paladinBound; ++min) {
                WitherlingEntity minionPaladin;
                if (this.checkPhase(400.0f)) {
                    minionPaladin = this.create(blockPos);
                    this.setMinionStats(minionPaladin, MinionType.PALADIN_1);
                    continue;
                }
                if (!this.checkPhase(200.0f)) continue;
                minionPaladin = this.create(blockPos);
                this.setMinionStats(minionPaladin, MinionType.PALADIN_2);
            }
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            entity.func_145747_a((ITextComponent)ToolTipUtils.translate(phaseText, TextFormatting.ITALIC), this.field_96093_i);
        }
        this.func_70106_y();
    }

    private void spawnMinions(WitherlingEntity minion, MinionType one, MinionType two, MinionType three, MinionType four) {
        if (this.checkPhase(800.0f)) {
            this.setMinionStats(minion, one);
        } else if (this.checkPhase(600.0f)) {
            this.setMinionStats(minion, two);
        } else if (this.checkPhase(400.0f)) {
            this.setMinionStats(minion, three);
        } else if (this.checkPhase(200.0f)) {
            this.setMinionStats(minion, four);
        }
    }

    private WitherlingEntity create(BlockPos pos) {
        WitherlingEntity minion = new WitherlingEntity((EntityType<? extends AbstractSkeletonEntity>)((EntityType)ModEntities.WITHERLING.get()), this.field_70170_p);
        minion.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)minion, new Class[0]));
        minion.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)minion, LivingEntity.class, 0, false, false, SkeletalKingEntity.ANY_ENTITY));
        minion.func_70634_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        minion.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Vector3i)minion.func_233580_cy_())), SpawnReason.TRIGGERED, null, null);
        this.field_70170_p.func_217376_c((Entity)minion);
        return minion;
    }

    private boolean checkPhase(float phase) {
        return true;
    }

    private boolean checkPhase(float phase, float rangeEnd) {
        return true;
    }

    private void setMinionStats(WitherlingEntity witherSkeleton, MinionType data) {
        this.setMinionStats(witherSkeleton, data.getName(), data.getHealth(), data.getWeapon(), data.getOffHand(), Utils.getItemStacks(data.getArmor()));
    }

    private void setMinionStats(WitherlingEntity minion, String type, double maxHealth, ItemStack mainHand, ItemStack offHand, NonNullList<ItemStack> equipedArmor) {
        minion.func_200203_b((ITextComponent)new StringTextComponent(String.format("%sSkeletal King's %s", TextFormatting.YELLOW, type)));
        minion.func_110148_a(Attributes.field_233818_a_).func_111128_a(maxHealth);
        minion.func_70691_i(minion.func_110138_aP());
        minion.func_70606_j(minion.func_110138_aP());
        minion.func_184611_a(Hand.MAIN_HAND, mainHand);
        minion.func_184611_a(Hand.OFF_HAND, offHand);
        minion.func_184201_a(EquipmentSlotType.HEAD, (ItemStack)equipedArmor.get(0));
        minion.func_184201_a(EquipmentSlotType.CHEST, (ItemStack)equipedArmor.get(1));
        minion.func_184201_a(EquipmentSlotType.LEGS, (ItemStack)equipedArmor.get(2));
        minion.func_184201_a(EquipmentSlotType.FEET, (ItemStack)equipedArmor.get(3));
        WitherMinionEntity.setDropChance(minion, EquipmentSlotType.MAINHAND, EquipmentSlotType.OFFHAND, EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET);
        minion.func_174805_g(true);
        minion.func_82142_c(false);
        minion.func_184224_h(false);
        minion.func_98053_h(true);
        minion.field_98038_p = true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
    }

    protected boolean func_184564_k() {
        return false;
    }

    public EntityType<?> func_200600_R() {
        return this.type;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

