/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.armors;

import com.sofodev.armorplus.ArmorPlus;
import com.sofodev.armorplus.registry.items.armors.APArmorProperties;
import com.sofodev.armorplus.registry.items.armors.IAPArmor;
import com.sofodev.armorplus.registry.items.extras.Buff;
import com.sofodev.armorplus.registry.items.extras.BuffInstance;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.TextFormatting;

public enum APArmorMaterial implements IAPArmor
{
    COAL((IArmorMaterial)APArmorProperties.COAL_PROP, TextFormatting.GRAY, new BuffInstance(Buff.NIGHT_VISION, 0)),
    REDSTONE((IArmorMaterial)APArmorProperties.REDSTONE_PROP, TextFormatting.DARK_RED, new BuffInstance(Buff.HASTE, 1)),
    LAPIS((IArmorMaterial)APArmorProperties.LAPIS_PROP, TextFormatting.DARK_BLUE, new BuffInstance(Buff.WATER_BREATHING, 0)),
    CHICKEN((IArmorMaterial)APArmorProperties.CHICKEN_PROP, TextFormatting.WHITE, new BuffInstance(Buff.SPEED, 3)),
    SLIME((IArmorMaterial)APArmorProperties.SLIME_PROP, TextFormatting.GREEN, new BuffInstance(Buff.JUMP_BOOST, 3), new BuffInstance(Buff.SLOW_FALLING, 1)),
    EMERALD((IArmorMaterial)APArmorProperties.EMERALD_PROP, TextFormatting.DARK_GREEN, new BuffInstance(Buff.SPEED, 1)),
    OBSIDIAN((IArmorMaterial)APArmorProperties.OBSIDIAN_PROP, TextFormatting.DARK_GRAY, new BuffInstance(Buff.RESISTANCE, 1)),
    INFUSED_LAVA((IArmorMaterial)APArmorProperties.INFUSED_LAVA_PROP, TextFormatting.GOLD, new BuffInstance(Buff.FIRE_RESISTANCE, 0)),
    GUARDIAN((IArmorMaterial)APArmorProperties.GUARDIAN_PROP, TextFormatting.BLUE, new BuffInstance(Buff.WATER_BREATHING, 0)),
    SUPER_STAR((IArmorMaterial)APArmorProperties.SUPER_STAR_PROP, TextFormatting.WHITE, new BuffInstance(Buff.WITHER_IMMUNITY), new BuffInstance(Buff.REGENERATION, 2)),
    ENDER_DRAGON((IArmorMaterial)APArmorProperties.ENDER_DRAGON_PROP, TextFormatting.DARK_PURPLE, new BuffInstance(Buff.FLIGHT), new BuffInstance(Buff.SLOW_FALLING, 0)),
    ARDITE((IArmorMaterial)APArmorProperties.ARDITE_PROP, TextFormatting.RED, new BuffInstance[0]),
    COBALT((IArmorMaterial)APArmorProperties.COBALT_PROP, TextFormatting.BLUE, new BuffInstance[0]),
    KNIGHT_SLIME((IArmorMaterial)APArmorProperties.KNIGHT_SLIME_PROP, TextFormatting.LIGHT_PURPLE, new BuffInstance[0]),
    PIG_IRON((IArmorMaterial)APArmorProperties.PIG_IRON_PROP, TextFormatting.LIGHT_PURPLE, new BuffInstance[0]),
    MANYULLYN((IArmorMaterial)APArmorProperties.MANYULLYN_PROP, TextFormatting.DARK_PURPLE, new BuffInstance[0]),
    SLAYER((IArmorMaterial)APArmorProperties.SLAYER_PROP, TextFormatting.DARK_PURPLE, new BuffInstance(Buff.FIRE_RESISTANCE, 0), new BuffInstance(Buff.WITHER_IMMUNITY), new BuffInstance(Buff.FLIGHT), new BuffInstance(Buff.WATER_BREATHING, 0)),
    CHAINMAIL(APArmorProperties.ENHANCED_CHAINMAIL_PROP),
    GOLDEN(APArmorProperties.ENHANCED_GOLD_PROP),
    IRON(APArmorProperties.ENHANCED_IRON_PROP),
    DIAMOND(APArmorProperties.ENHANCED_DIAMOND_PROP);

    private final IArmorMaterial armor;
    private final Item.Properties properties;
    private final BuffInstance[] buffs;
    private final TextFormatting formatting;

    private APArmorMaterial() {
        this((IArmorMaterial)ArmorMaterial.IRON, new Item.Properties(), TextFormatting.RESET, new BuffInstance[0]);
    }

    private APArmorMaterial(IArmorMaterial armor) {
        this(armor, new Item.Properties(), TextFormatting.RESET, new BuffInstance[0]);
    }

    private APArmorMaterial(IArmorMaterial armor, TextFormatting formatting, BuffInstance ... buffs) {
        this(armor, new Item.Properties(), formatting, buffs);
    }

    private APArmorMaterial(IArmorMaterial armor, Item.Properties properties, TextFormatting formatting, BuffInstance ... buffs) {
        this.armor = armor;
        this.properties = properties;
        this.buffs = buffs;
        this.formatting = formatting;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    @Override
    public IArmorMaterial get() {
        return this.armor;
    }

    @Override
    public TextFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public Item.Properties getProperties() {
        return this.properties.func_200916_a(ArmorPlus.AP_GROUP).func_208103_a(Rarity.create((String)this.getName(), (TextFormatting)this.getFormatting()));
    }

    @Override
    public BuffInstance[] getBuffInstances() {
        return this.buffs;
    }
}

