/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.registry.items.extras;

import com.sofodev.armorplus.registry.items.extras.IBuff;
import com.sofodev.armorplus.utils.Utils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.world.World;

public class BuffInstance {
    private final IBuff buff;
    private final boolean instant;
    private final Potion potion;

    public BuffInstance(IBuff buff, int amplifier) {
        this(buff, amplifier, 20, true);
    }

    public BuffInstance(IBuff buff, int amplifier, int duration) {
        this(buff, amplifier, duration, false);
    }

    public BuffInstance(IBuff buff, int amplifier, int duration, boolean instant) {
        this.buff = buff;
        this.instant = instant;
        this.potion = buff.isEffect() && buff.getEffect() != null ? new Potion(new EffectInstance[]{new EffectInstance(buff.getEffect(), Utils.convertToSeconds(duration), amplifier)}) : Potions.field_185229_a;
    }

    public BuffInstance(IBuff buff) {
        this.buff = buff;
        this.instant = true;
        this.potion = Potions.field_185229_a;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        this.buff.onArmorTick(stack, world, player);
        if (this.buff.isEffect()) {
            for (EffectInstance pot : this.getPotion().func_185170_a()) {
                if (!this.instant) {
                    if (player.func_70651_bq().contains(pot)) continue;
                    player.func_195064_c(pot);
                    continue;
                }
                player.func_195064_c(pot);
            }
        }
    }

    public void hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.buff.hitEntity(stack, target, attacker);
        if (this.buff.isEffect()) {
            this.getPotion().func_185170_a().forEach(arg_0 -> ((LivingEntity)target).func_195064_c(arg_0));
        }
    }

    public Potion getPotion() {
        return this.potion;
    }

    public IBuff getBuff() {
        return this.buff;
    }
}

