/*
 * Decompiled with CFR 0.152.
 */
package com.sofodev.armorplus.utils;

import com.sofodev.armorplus.utils.Loader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public final class Utils {
    public static ItemStack[] emptyArmor = new ItemStack[4];
    public static EquipmentSlotType[] equipmentSlots = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};

    public static List<String> boxList(String[] objects) {
        return Arrays.stream(objects).collect(Collectors.toList());
    }

    public static List<Integer> boxList(int[] objects) {
        return Arrays.stream(objects).boxed().collect(Collectors.toList());
    }

    public static int convertToSeconds(int seconds) {
        return seconds * 20;
    }

    public static ItemStack checkNBT(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        return stack;
    }

    public static ItemStack setUnbreakable(ItemStack stack) {
        Utils.checkNBT(stack);
        stack.func_77978_p().func_74757_a("Unbreakable", true);
        return stack;
    }

    public static ItemStack getStackFromSlot(PlayerEntity player, EquipmentSlotType slot) {
        return player.func_184582_a(slot);
    }

    public static String setName(String name) {
        return String.format("%s.%s", "armorplus", name);
    }

    public static NonNullList<ItemStack> getItemStacks(Item ... items) {
        NonNullList list = NonNullList.func_191196_a();
        if (items != null) {
            Arrays.stream(items).map(Utils::getItemStack).forEachOrdered(arg_0 -> list.add(arg_0));
        }
        return list;
    }

    public static NonNullList<ItemStack> getItemStacks(ItemStack ... items) {
        NonNullList list = NonNullList.func_191196_a();
        list.addAll(Arrays.asList(items));
        return list;
    }

    public static ItemStack getItemStack(Object type, int amount) {
        if (type instanceof String) {
            return new ItemStack((IItemProvider)Objects.requireNonNull(Utils.getItemByName((String)type)), amount);
        }
        if (type instanceof Block) {
            return new ItemStack((IItemProvider)((Block)type), amount);
        }
        return type instanceof Item ? new ItemStack((IItemProvider)((Item)type), amount) : ItemStack.field_190927_a;
    }

    public static ItemStack getItemStack(Object type) {
        if (type instanceof String) {
            return Utils.getItemStack(Utils.getItemByName((String)type), 0);
        }
        if (type instanceof Block) {
            return Utils.getItemStack(type, 0);
        }
        if (type instanceof Item) {
            return Utils.getItemStack(type, 0);
        }
        return type instanceof ItemStack ? (ItemStack)type : ItemStack.field_190927_a;
    }

    public static String getUnlocalizedNames(ItemStack stack, String key, String ... names) {
        for (int i = 0; i < names.length; ++i) {
            if (stack.func_77952_i() != i) continue;
            return key + names[i];
        }
        return key;
    }

    public static Item getItemByName(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name));
    }

    public static Item getAPItem(String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(Utils.setRL(name));
    }

    public static ResourceLocation setRL(String path) {
        return new ResourceLocation("armorplus", path);
    }

    public static ResourceLocation setVanillaLocation(String path) {
        return new ResourceLocation(path);
    }

    public static String setLocation(String path) {
        return String.format("%s:%s", "armorplus", path);
    }

    public static boolean isNotEmpty(ItemStack stack) {
        return !stack.func_190926_b();
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.func_190926_b();
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean areNotNull(Object object1, Object object2) {
        return object1 != null && object2 != null;
    }

    public static boolean isNotNullNorEmpty(String object) {
        return Utils.isNotNull(object) && !Objects.equals(object, "");
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNullOrEmpty(String object) {
        return Utils.isNull(object) || Objects.equals(object, "");
    }

    public static ItemStack getTCIngot(int meta) {
        if (Loader.TCONSTRUCT.isLoaded()) {
            Item ingot = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("tconstruct:ingots"));
            if (ingot != null) {
                return new ItemStack((IItemProvider)ingot, 1);
            }
            return ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public static String getNormalizedName(EquipmentSlotType slot) {
        if (slot == EquipmentSlotType.HEAD) {
            return "helmet";
        }
        if (slot == EquipmentSlotType.LEGS) {
            return "leggings";
        }
        if (slot == EquipmentSlotType.CHEST) {
            return "chestplate";
        }
        if (slot == EquipmentSlotType.FEET) {
            return "boots";
        }
        return slot.func_188450_d();
    }

    public static Path getForgeConfig() {
        return FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath());
    }

    public static Path getModConfig() {
        return Utils.getForgeConfig().resolve("armorplus.json");
    }

    public static boolean canAllowFlight(PlayerEntity player, boolean flag) {
        return flag || player.field_71075_bZ.field_75098_d || player.func_175149_v();
    }

    static {
        Arrays.fill(emptyArmor, ItemStack.field_190927_a);
    }
}

