/*
 * Decompiled with CFR 0.152.
 */
package sokratis12gr.armorplus.api.crafting;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import sokratis12gr.armorplus.api.crafting.IRecipe;
import sokratis12gr.armorplus.api.crafting.InventoryCrafting;

public class ShapedRecipes
implements IRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    private final ItemStack recipeOutput;
    private boolean copyIngredientNBT;

    public ShapedRecipes(int width, int height, ItemStack[] p_i1917_3_, ItemStack output) {
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = p_i1917_3_;
        this.recipeOutput = output;
    }

    @Override
    @Nullable
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public ItemStack[] getRemainingItems(InventoryCrafting inv) {
        ItemStack[] aitemstack = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }

    @Override
    public boolean matches(InventoryCrafting inv, World worldIn) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting p_77573_1_, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack1;
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                ItemStack itemstack = null;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    itemstack = p_77573_4_ ? this.recipeItems[this.recipeWidth - k - 1 + l * this.recipeWidth] : this.recipeItems[k + l * this.recipeWidth];
                }
                if ((itemstack1 = p_77573_1_.getStackInRowAndColumn(i, j)) == null && itemstack == null) continue;
                if (itemstack1 == null && itemstack != null || itemstack1 != null && itemstack == null) {
                    return false;
                }
                if (itemstack.func_77973_b() != itemstack1.func_77973_b()) {
                    return false;
                }
                if (itemstack.func_77960_j() == Short.MAX_VALUE || itemstack.func_77960_j() == itemstack1.func_77960_j()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack itemstack = this.getRecipeOutput().func_77946_l();
        if (this.copyIngredientNBT) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack itemstack1 = inv.func_70301_a(i);
                if (itemstack1 == null || !itemstack1.func_77942_o()) continue;
                itemstack.func_77982_d((NBTTagCompound)itemstack1.func_77978_p().func_74737_b());
            }
        }
        return itemstack;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }
}

