/*
 * Decompiled with CFR 0.152.
 */
package sokratis12gr.armorplus.compat.jei.armorforge;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import sokratis12gr.armorplus.api.crafting.ShapelessRecipes;
import sokratis12gr.armorplus.compat.jei.armorforge.ArmorForgeShapelessRecipeWrapper;

public class ArmorForgeShapelessRecipeHandler
implements IRecipeHandler<ShapelessRecipes> {
    @Nonnull
    private final IGuiHelper guiHelper;

    public ArmorForgeShapelessRecipeHandler(@Nonnull IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @Nonnull
    public Class<ShapelessRecipes> getRecipeClass() {
        return ShapelessRecipes.class;
    }

    @Nonnull
    public String getRecipeCategoryUid() {
        return "armorplus:ArmorForge";
    }

    @Nonnull
    public String getRecipeCategoryUid(@Nonnull ShapelessRecipes recipe) {
        return "armorplus:ArmorForge";
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull ShapelessRecipes recipe) {
        return new ArmorForgeShapelessRecipeWrapper(this.guiHelper, recipe);
    }

    public boolean isRecipeValid(@Nonnull ShapelessRecipes recipe) {
        if (recipe.getRecipeOutput() == null) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe((Object)recipe, (IRecipeHandler)this);
            Log.error((String)"Recipe has no output. {}", (Object[])new Object[]{recipeInfo});
            return false;
        }
        int inputCount = 0;
        for (ItemStack input : recipe.recipeItems) {
            if (input instanceof ItemStack) {
                ++inputCount;
                continue;
            }
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe((Object)recipe, (IRecipeHandler)this);
            Log.error((String)"Recipe has an input that is not an ItemStack. {}", (Object[])new Object[]{recipeInfo});
            return false;
        }
        if (inputCount > 9) {
            String recipeInfo = ErrorUtil.getInfoFromBrokenRecipe((Object)recipe, (IRecipeHandler)this);
            Log.error((String)"Recipe has too many inputs. {}", (Object[])new Object[]{recipeInfo});
            return false;
        }
        return inputCount > 0;
    }
}

