/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.info;

import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.storageformat.StorageFormatRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BackupInfoUtil {
    private BackupInfoUtil() {
    }

    public static List<IBackupInfo> listBackups(File path) throws IOException {
        return StorageFormatRegistry.INSTANCE.listBackups(path);
    }

    public static List<IBackupInfo> listBackupsForWorld(File path, String world) throws IOException {
        ArrayList<String> acceptedWorldNames = new ArrayList<String>();
        acceptedWorldNames.add(world);
        while (world.endsWith("_old")) {
            world = world.substring(0, world.length() - "_old".length());
            acceptedWorldNames.add(world);
        }
        List<IBackupInfo> list = BackupInfoUtil.listBackups(path);
        list.removeIf(info -> !acceptedWorldNames.contains(info.getBackupStats().getWorldName()));
        return list;
    }

    public static IBackupInfo getNextParentFor(File dir, String worldName) throws IOException {
        List<IBackupInfo> info = BackupInfoUtil.listBackupsForWorld(dir, worldName);
        if (info.isEmpty()) {
            return null;
        }
        return Collections.max(info);
    }
}

