/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.recovery;

import aroma1997.backup.common.storageformat.IBackupInfo;
import aroma1997.backup.common.util.Environment;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RestoreChunkInfo {
    private int x;
    private int z;
    private IBackupInfo info;

    public RestoreChunkInfo(int x, int z, IBackupInfo binfo) {
        this.x = x;
        this.z = z;
        this.info = binfo;
    }

    public boolean matches(int x, int z) {
        return x == this.x && z == this.z;
    }

    public Collection<ChunkPos> getChunkPositions() {
        return Collections.singleton(new ChunkPos(this.x, this.z));
    }

    public File getFile() {
        File file = Environment.getEnv().getTmpDir(this.info.getFile().getName());
        if (!file.exists() || !file.isDirectory()) {
            try {
                this.info.getStorageFormat().restoreBackup(this.info, f -> new File(file, f));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new File(file, this.info.getBackupStats().getWorldName());
    }
}

