/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.standalone.command;

import aroma1997.backup.common.util.IOHelper;
import aroma1997.backup.standalone.command.Command;
import aroma1997.backup.standalone.command.CommandException;
import aroma1997.backup.standalone.command.CommandHelp;
import aroma1997.backup.standalone.command.ICommandRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class CommandRegistry
implements ICommandRegistry {
    private static final CommandRegistry INSTANCE = new CommandRegistry();
    private Map<String, Command> commandMap = new HashMap<String, Command>();
    public static final Command UNKNOWN_COMMAND = new Command(new String[]{"UnknownCommand"}){

        @Override
        public void execute(String[] args) {
            throw new UnsupportedOperationException();
        }
    };
    static final String INVALID_COMMAND = "This is not a valid command. Please enter a valid command name.";

    CommandRegistry() {
    }

    @Override
    public void execute(String[] args) {
        if (args == null || args.length == 0) {
            IOHelper.printUserOut(INVALID_COMMAND);
            return;
        }
        Command command = this.getCommand(args[0]);
        if (command == UNKNOWN_COMMAND) {
            IOHelper.printUserOut(INVALID_COMMAND);
            return;
        }
        try {
            command.execute(this.dropFirstIndex(args));
        }
        catch (CommandException e) {
            IOHelper.printUserOut(e.getMessage());
        }
    }

    @Override
    public Command getCommand(String name) {
        String nameNew = name.toLowerCase();
        if (this.commandMap.containsKey(nameNew)) {
            return this.commandMap.get(nameNew);
        }
        for (Command command : this.commandMap.values()) {
            if (!command.getCommandAliases().contains(nameNew)) continue;
            return command;
        }
        return UNKNOWN_COMMAND;
    }

    public static CommandRegistry getInstance() {
        return INSTANCE;
    }

    String[] dropFirstIndex(String[] origin) {
        if (origin == null || origin.length <= 1) {
            return new String[0];
        }
        String[] ret = new String[origin.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = origin[i + 1];
        }
        return ret;
    }

    @Override
    public void registerCommand(Command command) {
        if (command == null) {
            IOHelper.printDebugOut("Something tried to register a null command to CommandRegistry.");
            return;
        }
        if (this.commandMap.containsKey(command.getName())) {
            IOHelper.printDebugOut("Something tried to register a command, that already exists.");
            return;
        }
        this.commandMap.put(command.getName().toLowerCase(), command);
    }

    Collection<Command> getRegisteredCommands() {
        return this.commandMap.values();
    }

    public static String[] splitIntoArgs(String str) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean escapedQuote = false;
        boolean escapedBackslash = false;
        for (char c : str.toCharArray()) {
            if (escapedBackslash) {
                builder.append(c);
                escapedBackslash = false;
                continue;
            }
            if (c == '\\') {
                escapedBackslash = true;
                continue;
            }
            if (c == '\"') {
                escapedQuote = !escapedQuote;
                continue;
            }
            if (escapedQuote || c != ' ') {
                builder.append(c);
                continue;
            }
            args.add(builder.toString());
            builder = new StringBuilder();
        }
        args.add(builder.toString());
        return args.toArray(new String[0]);
    }

    public static String addEscapes(String string) {
        StringBuilder sb = new StringBuilder();
        for (char c : string.toCharArray()) {
            switch (c) {
                case ' ': 
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        INSTANCE.registerCommand(new CommandHelp(INSTANCE));
    }
}

