/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.org.kamranzafar.jtar;

import java.io.File;

public class TarUtils {
    public static long calculateTarSize(File path) {
        return TarUtils.tarSize(path) + 1024L;
    }

    private static long tarSize(File dir) {
        long size = 0L;
        if (dir.isFile()) {
            return TarUtils.entrySize(dir.length());
        }
        File[] subFiles = dir.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            for (File file : subFiles) {
                if (file.isFile()) {
                    size += TarUtils.entrySize(file.length());
                    continue;
                }
                size += TarUtils.tarSize(file);
            }
        } else {
            return 512L;
        }
        return size;
    }

    private static long entrySize(long fileSize) {
        long size = 0L;
        size += 512L;
        long extra = (size += fileSize) % 512L;
        if (extra > 0L) {
            size += 512L - extra;
        }
        return size;
    }

    public static String trim(String s, char c) {
        int i;
        StringBuffer tmp = new StringBuffer(s);
        for (i = 0; i < tmp.length() && tmp.charAt(i) == c; ++i) {
            tmp.deleteCharAt(i);
        }
        for (i = tmp.length() - 1; i >= 0 && tmp.charAt(i) == c; --i) {
            tmp.deleteCharAt(i);
        }
        return tmp.toString();
    }
}

