/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client;

import aroma1997.core.client.util.Colors;
import aroma1997.core.log.LogHelper;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerInfo {
    private static final Map<String, ObjectType<?>> types = new HashMap();
    public static final ObjectType<String> CAPE = PlayerInfo.addType(new ObjectType<String>("cape", element -> element.getAsString()));
    public static final ObjectType<Colors> COLOR = PlayerInfo.addType(new ObjectType<Colors>("color", element -> Colors.getColor(element.getAsString())));
    public static final ObjectType<String> LOGIN_MSG = PlayerInfo.addType(new ObjectType<String>("loginmsg", element -> element.getAsString()));
    public static final ObjectType<Integer> STAR = PlayerInfo.addType(new ObjectType<Integer>("star", element -> Integer.decode(element.getAsString())));
    private final Map<ObjectType<?>, Object> values = new HashMap();
    private final UUID name;

    public PlayerInfo(UUID name) {
        this.name = name;
    }

    public UUID getName() {
        return this.name;
    }

    public void add(String key, JsonElement element) {
        ObjectType<?> type = types.get(key);
        if (type == null) {
            LogHelper.debugLog("Found unknown key for type: " + key);
            return;
        }
        this.values.put(type, type.resolve(element));
    }

    public <T> T get(ObjectType<T> type) {
        return type.cast(this.values.get(type));
    }

    private static <T> ObjectType<T> addType(ObjectType<T> type) {
        types.put(((ObjectType)type).name, type);
        return type;
    }

    public static class ObjectType<T> {
        private final String name;
        private final Function<JsonElement, T> func;

        public ObjectType(String name, Function<JsonElement, T> resolver) {
            this.name = name;
            this.func = resolver;
        }

        public String getName() {
            return this.name;
        }

        public T resolve(JsonElement element) {
            return this.func.apply(element);
        }

        T cast(Object o) {
            return (T)o;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

