/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.container;

import aroma1997.core.Aroma1997Core;
import aroma1997.core.client.gui.GuiDebug;
import aroma1997.core.container.ContainerDebug;
import aroma1997.core.container.IGuiProvider;
import gnu.trove.map.TShortObjectMap;
import gnu.trove.map.hash.TShortObjectHashMap;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerHelper {
    public static final int TYPE_BITS = 16;
    public static final int TYPE_MASK = 65535;
    public static final int ID_BITS = 16;
    public static final int ID_MASK = 65535;
    public static final int SLOT_BITS = 6;
    public static final int SLOT_MASK = 63;
    public static final int ITEM_ID_BITS = 10;
    public static final int ITEM_ID_MASK = 1023;
    private static final TShortObjectMap<IGuiProvider> registeredGuis = new TShortObjectHashMap();

    public static short getId(int id) {
        return (short)(id & 0xFFFF);
    }

    static void openGui(EntityPlayer player, GuiType type, World world, BlockPos pos, short id) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.openGui((Object)Aroma1997Core.instance, type.ordinal() << 16 | id & 0xFFFF, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static <T extends TileEntity> void openGui(T te, EntityPlayer player, short id) {
        ContainerHelper.openGui(player, GuiType.TILEENTITY, te.func_145831_w(), te.func_174877_v(), id);
    }

    public static void openGui(EntityPlayer player, int slot, short id) {
        ContainerHelper.openGui(player, slot, id, player.func_180425_c());
    }

    public static void openGui(EntityPlayer player, int slot, short id, BlockPos pos) {
        if (id >>> 10 != 0) {
            throw new IllegalArgumentException("Id not supported.");
        }
        if (slot < 0 || slot >= player.field_71071_by.func_70302_i_()) {
            throw new IllegalArgumentException("Slot out of bounds.");
        }
        ContainerHelper.openGui(player, GuiType.SLOT, player.field_70170_p, pos, (short)(slot << 10 | id));
    }

    public static IGuiProvider getGuiProvider(int id, EntityPlayer player, World world, int x, int y, int z) {
        int current = id >>> 16;
        GuiType type = GuiType.values()[current];
        return type.getGuiProvider(player, world, new BlockPos(x, y, z), (short)(id & 0xFFFF));
    }

    public static void openRegisteredGui(EntityPlayer player, short id) {
        ContainerHelper.openGui(player, GuiType.REGISTERED, player.func_130014_f_(), player.func_180425_c(), id);
    }

    public static void registerGui(short id, IGuiProvider guiProvider) {
        registeredGuis.put(id, (Object)guiProvider);
    }

    static {
        ContainerHelper.registerGui((short)0, new IGuiProvider(){

            @Override
            public Container getContainer(EntityPlayer player, short id) {
                return new ContainerDebug(player);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public Gui getGui(EntityPlayer player, short id) {
                return new GuiDebug(new ContainerDebug(player));
            }
        });
    }

    public static enum GuiType {
        TILEENTITY{

            @Override
            public IGuiProvider getGuiProvider(EntityPlayer player, World world, BlockPos pos, short id) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof IGuiProvider) {
                    return (IGuiProvider)te;
                }
                return null;
            }
        }
        ,
        SLOT{

            @Override
            public IGuiProvider getGuiProvider(EntityPlayer player, World world, BlockPos pos, short id) {
                int slot = id >>> 10 & 0x3F;
                ItemStack stack = player.field_71071_by.func_70301_a(slot);
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof IGuiProvider.IItemGuiProvider) {
                    final IGuiProvider parent = ((IGuiProvider.IItemGuiProvider)stack.func_77973_b()).getGuiProvider(player, stack);
                    return new IGuiProvider(){

                        @Override
                        public Container getContainer(EntityPlayer player, short id) {
                            return parent.getContainer(player, (short)(id & 0x3FF));
                        }

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public Gui getGui(EntityPlayer player, short id) {
                            return parent.getGui(player, (short)(id & 0x3FF));
                        }
                    };
                }
                return null;
            }
        }
        ,
        REGISTERED{

            @Override
            public IGuiProvider getGuiProvider(EntityPlayer player, World world, BlockPos pos, short id) {
                return (IGuiProvider)registeredGuis.get(id);
            }
        };


        public abstract IGuiProvider getGuiProvider(EntityPlayer var1, World var2, BlockPos var3, short var4);
    }
}

