/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.misc;

import java.util.function.Function;
import net.minecraft.util.EnumFacing;

public class CachedCapabilityProvider<T> {
    private final Function<EnumFacing, T> initializer;
    private final Object[] cache = new Object[EnumFacing.field_82609_l.length + 1];
    private final boolean[] cacheInitialized = new boolean[this.cache.length];

    public CachedCapabilityProvider(Function<EnumFacing, T> initializer) {
        this.initializer = initializer;
    }

    public T get(EnumFacing side) {
        Object ret;
        int idx = this.getIndex(side);
        if (this.cacheInitialized[idx]) {
            ret = this.cache[idx];
        } else {
            ret = this.cache[idx] = this.initializer.apply(side);
            this.cacheInitialized[idx] = true;
        }
        return (T)ret;
    }

    private int getIndex(EnumFacing side) {
        if (side == null) {
            return this.cache.length - 1;
        }
        return side.ordinal();
    }
}

