/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.inventories;

import aroma1997.core.client.inventories.RenderHelper;
import aroma1997.core.inventories.IProgressable;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractSpecialImage {
    private int x;
    private int y;

    public AbstractSpecialImage(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public abstract float getProgress();

    protected abstract boolean progressX();

    protected abstract boolean inverted();

    public int getStartX() {
        if (!this.progressX() || !this.inverted()) {
            return this.getMinX();
        }
        return this.getMinX() + (int)((float)this.getMaxSizeX() * this.getProgress());
    }

    public int getStartY() {
        if (this.progressX() || !this.inverted()) {
            return this.getMinY();
        }
        return this.getMinY() + (int)((float)this.getMaxSizeY() * this.getProgress());
    }

    public int getSizeX() {
        if (!this.progressX()) {
            return this.getMaxSizeX();
        }
        return (int)((float)this.getMaxSizeX() * this.getProgress());
    }

    public int getSizeY() {
        if (this.progressX()) {
            return this.getMaxSizeY();
        }
        return (int)((float)this.getMaxSizeY() * this.getProgress());
    }

    public void draw(Gui gui) {
        RenderHelper.bindTexture(this.getRL());
        gui.func_73729_b(this.getStartX(), this.getStartY(), this.getMinX(), this.getMinY(), this.getSizeX(), this.getSizeY());
        if (this.getBackgroundX() != -1) {
            gui.func_73729_b(this.getPosX(), this.getPosY(), this.getBackgroundX(), this.getBackgroundY(), this.getMaxSizeX(), this.getMaxSizeY());
        }
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    protected abstract int getMinX();

    protected abstract int getMaxSizeX();

    protected abstract int getMinY();

    protected abstract int getMaxSizeY();

    public abstract ResourceLocation getRL();

    public abstract int getBackgroundX();

    public abstract int getBackgroundY();

    public static abstract class ProgressableImage
    extends AbstractSpecialImage {
        private IProgressable prog;

        public ProgressableImage(int x, int y, IProgressable prog) {
            super(x, y);
            this.prog = prog;
        }

        @Override
        public float getProgress() {
            return this.prog.getProgress(this);
        }
    }
}

