/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup;

import aroma1997.backup.AromaBackup;
import aroma1997.backup.BackupInformation;
import aroma1997.backup.Config;
import aroma1997.backup.ThreadSchedule;
import aroma1997.backup.WorldIndex;
import aroma1997.backup.api.BackupEvent;
import aroma1997.core.log.LogHelper;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.util.Util;
import aroma1997.core.util.file.compression.ZipCompression;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ThreadBackup
extends Thread {
    private Object marker;
    private static ThreadBackup current = null;
    static boolean shouldBackup;

    private ThreadBackup() {
        current = this;
        this.setName("AromaBackup");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block29: {
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server == null) {
                LogHelper.debugLog((String)"Server instance was null. Stopping Backup.");
                this.finish();
                return;
            }
            LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)StatCollector.func_74838_a((String)("aromabackup:backup.start." + ThreadBackup.getSideString())));
            try {
                ThreadBackup.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.setLevelSaving(false);
            Set<Map.Entry<File, String>> additionalFiles = ThreadBackup.getNewAdditionalFilesList();
            try {
                MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.BackupStartEvent(additionalFiles));
            }
            catch (Exception e) {
                LogHelper.logException((String)"AromaBackup caught an exception from its API. Most likely, there is a mod causing issues.", (Throwable)e);
                AromaBackup.instance.logger.log(Level.WARN, "Continuing backup anyways. Some additional files may not be backed up.");
            }
            Object e = this.marker = new Object();
            synchronized (e) {
                try {
                    AromaBackup.instance.logger.log(Level.INFO, "Suspending Server Thread.");
                    this.marker.wait();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                this.save();
                this.marker.notify();
                AromaBackup.instance.logger.log(Level.INFO, "Continuing Server Thread.");
                this.marker = null;
            }
            LogHelper.debugLog((String)"Saved the world.");
            LogHelper.debugLog((String)"Waited for 2 seconds.");
            long delay = 0L;
            Calendar d = Calendar.getInstance();
            BackupInformation binfo = new BackupInformation(Util.getWorldName(), d.get(1), d.get(2) + 1, d.get(5), d.get(11), d.get(12));
            LogHelper.debugLog((String)"Created BackupInfo.");
            File dir = binfo.getDir();
            File to = binfo.getFile();
            dir.mkdirs();
            LogHelper.debugLog((String)"Created dirs.");
            this.compress(to.getCanonicalPath(), additionalFiles);
            LogHelper.debugLog((String)"Compressed the Backed up world.");
            WorldIndex.add(binfo);
            WorldIndex.save();
            LogHelper.debugLog((String)"Saved the World Index.");
            delay = Config.instance.delay;
            LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)StatCollector.func_74838_a((String)("aromabackup:backup.done." + ThreadBackup.getSideString())));
            LogHelper.debugLog((String)"Setting next Backup.");
            ThreadSchedule.nextbackup = System.currentTimeMillis() + delay;
            LogHelper.debugLog((String)("Next Backup set to: " + delay / 1000L + " seconds."));
            this.setLevelSaving(true);
            LogHelper.debugLog((String)"Turned on world autosaving.");
            LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)StatCollector.func_74837_a((String)("aromabackup:backup.next." + ThreadBackup.getSideString()), (Object[])new Object[]{"" + delay / 60000L}));
            try {
                if (Config.instance.toKeep != 0) {
                    int removes = WorldIndex.getList().size() - Config.instance.toKeep;
                    for (int i = 0; i < removes; ++i) {
                        BackupInformation binfo2 = WorldIndex.getList().get(i);
                        to = binfo2.getFile();
                        to.delete();
                        File dir2 = binfo2.getDir();
                        while (dir2.list() != null && dir2.list().length == 0) {
                            dir2.delete();
                            if ((dir2 = dir2.getParentFile()) != null) continue;
                        }
                    }
                }
                LogHelper.debugLog((String)"Deleted Old Backups.");
            }
            catch (Exception e3) {
                LogHelper.logException((String)"Failed to delete old backups.", (Throwable)e3);
                LogHelper.log((Level)Level.ERROR, (String)"This is a problem, you may want to solve it...");
            }
            this.finish();
            break block29;
            catch (Exception e4) {
                delay = Config.instance.delay / 2L;
                LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)StatCollector.func_74838_a((String)("aromabackup:backup.failed." + ThreadBackup.getSideString())));
                LogHelperPre.logException((String)"Failed Server Backup!", (Throwable)e4);
                LogHelper.debugLog((String)"Setting next Backup.");
                ThreadSchedule.nextbackup = System.currentTimeMillis() + delay;
                LogHelper.debugLog((String)("Next Backup set to: " + delay / 1000L + " seconds."));
                this.setLevelSaving(true);
                LogHelper.debugLog((String)"Turned on world autosaving.");
                LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)StatCollector.func_74837_a((String)("aromabackup:backup.next." + ThreadBackup.getSideString()), (Object[])new Object[]{"" + delay / 60000L}));
                try {
                    if (Config.instance.toKeep != 0) {
                        int removes = WorldIndex.getList().size() - Config.instance.toKeep;
                        for (int i = 0; i < removes; ++i) {
                            BackupInformation binfo3 = WorldIndex.getList().get(i);
                            to = binfo3.getFile();
                            to.delete();
                            File dir3 = binfo3.getDir();
                            while (dir3.list() != null && dir3.list().length == 0) {
                                dir3.delete();
                                if ((dir3 = dir3.getParentFile()) != null) continue;
                            }
                        }
                    }
                    LogHelper.debugLog((String)"Deleted Old Backups.");
                }
                catch (Exception e5) {
                    LogHelper.logException((String)"Failed to delete old backups.", (Throwable)e5);
                    LogHelper.log((Level)Level.ERROR, (String)"This is a problem, you may want to solve it...");
                }
                this.finish();
                catch (Throwable throwable) {
                    LogHelper.debugLog((String)"Setting next Backup.");
                    ThreadSchedule.nextbackup = System.currentTimeMillis() + delay;
                    LogHelper.debugLog((String)("Next Backup set to: " + delay / 1000L + " seconds."));
                    this.setLevelSaving(true);
                    LogHelper.debugLog((String)"Turned on world autosaving.");
                    LogHelper.sendMessageToPlayers((Logger)AromaBackup.instance.logger, (String)StatCollector.func_74837_a((String)("aromabackup:backup.next." + ThreadBackup.getSideString()), (Object[])new Object[]{"" + delay / 60000L}));
                    try {
                        if (Config.instance.toKeep != 0) {
                            int removes = WorldIndex.getList().size() - Config.instance.toKeep;
                            for (int i = 0; i < removes; ++i) {
                                BackupInformation binfo4 = WorldIndex.getList().get(i);
                                File to2 = binfo4.getFile();
                                to2.delete();
                                File dir4 = binfo4.getDir();
                                while (dir4.list() != null && dir4.list().length == 0) {
                                    dir4.delete();
                                    if ((dir4 = dir4.getParentFile()) != null) continue;
                                }
                            }
                        }
                        LogHelper.debugLog((String)"Deleted Old Backups.");
                    }
                    catch (Exception e6) {
                        LogHelper.logException((String)"Failed to delete old backups.", (Throwable)e6);
                        LogHelper.log((Level)Level.ERROR, (String)"This is a problem, you may want to solve it...");
                    }
                    this.finish();
                    throw throwable;
                }
            }
        }
    }

    private void setLevelSaving(boolean value) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        for (int i = 0; i < server.field_71305_c.length; ++i) {
            if (server.field_71305_c[i] == null) continue;
            WorldServer worldserver = server.field_71305_c[i];
            if (!Config.instance.shouldSaveDimension(worldserver.field_73011_w.field_76574_g)) continue;
            worldserver.field_73058_d = !value;
        }
    }

    private void save() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server.func_71203_ab() != null) {
            LogHelper.debugLog((String)"Saved Player data.");
            server.func_71203_ab().func_72389_g();
        }
        try {
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                try {
                    WorldServer worldserver = server.field_71305_c[i];
                    if (!Config.instance.shouldSaveDimension(worldserver.field_73011_w.field_76574_g)) {
                        LogHelper.debugLog((String)("Skipping Dimension " + worldserver.field_73011_w.field_76574_g + " on backup."));
                        continue;
                    }
                    LogHelper.debugLog((String)("Saving Dimension " + worldserver.field_73011_w.field_76574_g + " on backup."));
                    worldserver.func_73044_a(true, (IProgressUpdate)null);
                    worldserver.func_104140_m();
                    continue;
                }
                catch (Throwable t) {
                    AromaBackup.instance.logger.log(Level.ERROR, "Failed to save dimension " + i + " continuing with the next dimension.");
                    AromaBackup.instance.logger.log(Level.ERROR, "This is not AromaBackup's fault. I't probably caused by a block in that world.");
                    AromaBackup.instance.logger.log(Level.ERROR, "If you want to report it, report it to that block's author.");
                    LogHelper.logException((String)"Failed dimension save.", (Throwable)t);
                }
            }
        }
        catch (Throwable t) {
            AromaBackup.instance.logger.log(Level.FATAL, "Failed to save the world. This is a severe error. Please report this.");
            LogHelper.logException((String)"Failed to save the world.", (Throwable)t);
        }
    }

    private void compress(String to, Set<Map.Entry<File, String>> additionalFiles) throws Exception {
        FileOutputStream fos = new FileOutputStream(to);
        ZipOutputStream zip = new ZipOutputStream(fos);
        zip.setLevel(Config.instance.compressionRate);
        File[] files = Util.getWorldFolder().listFiles();
        ArrayList<String> folders = new ArrayList<String>();
        for (File file : files) {
            LogHelper.debugLog((String)file.getCanonicalPath());
            if (file.isFile()) {
                ZipCompression.addFileToZip((String)Util.getWorldName(), (String)file.getCanonicalPath(), (ZipOutputStream)zip);
                continue;
            }
            folders.add(file.getName());
        }
        for (File file : MinecraftServer.func_71276_C().field_71305_c) {
            if (file == null) continue;
            String name = ((WorldServer)file).field_73011_w.getSaveFolder();
            if (Config.instance.shouldSaveDimension(((WorldServer)file).field_73011_w.field_76574_g) || !folders.contains(name)) continue;
            folders.remove(name);
        }
        for (String string : folders) {
            ZipCompression.addFolderToZip((String)Util.getWorldName(), (String)new File(Util.getWorldFolder(), string).getCanonicalPath(), (ZipOutputStream)zip);
        }
        for (Map.Entry entry : additionalFiles) {
            if (((File)entry.getKey()).isFile()) {
                ZipCompression.addFileToZip((String)("additionalfiles/" + (String)entry.getValue()), (String)((File)entry.getKey()).getCanonicalPath(), (ZipOutputStream)zip);
                continue;
            }
            ZipCompression.addFolderToZip((String)("additionalfiles/" + (String)entry.getValue()), (String)((File)entry.getKey()).getCanonicalPath(), (ZipOutputStream)zip);
        }
        zip.flush();
        zip.close();
    }

    private void finish() {
        shouldBackup = MinecraftServer.func_71276_C().func_71213_z().length > 0;
        shouldBackup = shouldBackup || MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.size() > 0;
        try {
            MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.BackupDoneEvent());
        }
        catch (Exception e) {
            LogHelper.logException((String)"AromaBackup caught an exception from its API. Most likely, there is a mod causing issues.", (Throwable)e);
        }
        LogHelper.debugLog((String)"Finished.");
        current = null;
    }

    public Object getMarker() {
        return this.marker;
    }

    public static boolean isRunning() {
        return current != null;
    }

    static ThreadBackup getInstance() {
        return current;
    }

    public static boolean doBackup() {
        return ThreadBackup.doBackup(false);
    }

    public static boolean doBackup(boolean force) {
        if (ThreadBackup.isRunning()) {
            LogHelper.debugLog((String)"Not doing a backup, because another backup is already running.");
            return false;
        }
        if (!force && Config.instance.skipBackup && !shouldBackup) {
            AromaBackup.instance.logger.log(Level.INFO, "Skipping world backup because no players were on the server.");
            ThreadSchedule.nextbackup = System.currentTimeMillis() + Config.instance.delay;
            AromaBackup.instance.logger.log(Level.INFO, "Next Backup in: " + (ThreadSchedule.nextbackup - System.currentTimeMillis() + 1L) / 60000L + " minutes.");
            return false;
        }
        new ThreadBackup();
        return true;
    }

    private static String getSideString() {
        return FMLCommonHandler.instance().getSide().toString().toLowerCase();
    }

    private static Set<Map.Entry<File, String>> getNewAdditionalFilesList() {
        return new HashSet<Map.Entry<File, String>>(){

            @Override
            public boolean add(Map.Entry<File, String> e) {
                if (!e.getKey().exists()) {
                    return false;
                }
                return super.add(e);
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<File, String>> c) {
                for (Map.Entry<File, String> entry : c) {
                    if (this.add(entry)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object arg0) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> arg0) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> arg0) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

