/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup;

import aroma1997.backup.AromaBackup;
import aroma1997.backup.BackupInformation;
import aroma1997.backup.Config;
import aroma1997.core.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.Level;

public class WorldIndex {
    private static ArrayList<BackupInformation> info = new ArrayList();

    static void load() {
        File file = WorldIndex.getFile();
        if (!file.exists()) {
            info.clear();
            AromaBackup.instance.logger.log(Level.INFO, "Could not find backupstore.txt file.");
            AromaBackup.instance.logger.log(Level.INFO, "It will be created, when the first backup is done.");
        } else {
            try {
                String string;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                info.clear();
                while ((string = reader.readLine()) != null) {
                    info.add(BackupInformation.loadFromString(string));
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(info);
    }

    static void add(BackupInformation binf) {
        info.add(binf);
    }

    static void save() {
        Collections.sort(info);
        File file = WorldIndex.getFile();
        try {
            FileWriter wr = new FileWriter(file);
            for (int i = 0; i < info.size(); ++i) {
                BackupInformation binfo = info.get(i);
                if (!binfo.exists()) continue;
                wr.write(binfo.toString() + "\r\n");
            }
            wr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getFile() {
        return new File(Config.instance.location + "/" + Util.getWorldName() + "/backupstore.txt");
    }

    static ArrayList<BackupInformation> getList() {
        return info;
    }
}

