/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.item;

import com.shoxie.audiocassettes.audiocassettes;
import com.shoxie.audiocassettes.capability.WalkmanCapability;
import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import com.shoxie.audiocassettes.networking.Networking;
import com.shoxie.audiocassettes.networking.SWalkmanPlayPacket;
import com.shoxie.audiocassettes.networking.SWalkmanStopPacket;
import com.shoxie.audiocassettes.networking.WalkmanOnDropPacket;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WalkmanItem
extends Item {
    private static String name = "walkman";
    public static final int ID = 3;

    public WalkmanItem() {
        this.func_77655_b(name);
        this.setRegistryName(name);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.field_77777_bU = 1;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (worldIn.field_72995_K) {
            new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184586_b(handIn));
        }
        playerIn.openGui((Object)audiocassettes.instance, 3, worldIn, playerIn.func_180425_c().func_177958_n(), playerIn.func_180425_c().func_177956_o(), playerIn.func_180425_c().func_177952_p());
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack mp) {
        if (!mp.func_77942_o()) {
            WalkmanItem.getID(mp);
        }
        NBTTagCompound nbt = mp.func_77978_p();
        IItemHandler h = (IItemHandler)mp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        nbt.func_74782_a("walkman", Objects.requireNonNull(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)h, null)));
        return nbt;
    }

    public void readNBTShareTag(ItemStack mp, @Nullable NBTTagCompound nbt) {
        super.readNBTShareTag(mp, nbt);
        if (nbt != null) {
            IItemHandler h = (IItemHandler)mp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)h, null, nbt.func_74781_a("walkman"));
        }
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean onDroppedByPlayer(ItemStack mp, EntityPlayer player) {
        Networking.INSTANCE.sendToServer((IMessage)new WalkmanOnDropPacket(mp));
        return true;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new WalkmanCapability();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (WalkmanItem.getCassette(stack).func_77973_b() instanceof AbstractAudioCassetteItem) {
            tooltip.add(ForgeHooks.newChatWithLinks((String)("Current Song: " + AbstractAudioCassetteItem.getCurrentSlot(WalkmanItem.getCassette(stack)) + ". " + AbstractAudioCassetteItem.getSongTitle(WalkmanItem.getCassette(stack)))).func_150254_d());
        }
    }

    public static void setTagBool(ItemStack mp, String name, boolean val) {
        if (mp.func_77973_b() instanceof WalkmanItem) {
            int intval = val ? 1 : 0;
            NBTTagCompound nbt = mp.func_77942_o() ? mp.func_77978_p() : new NBTTagCompound();
            nbt.func_74768_a(name, intval);
            mp.func_77982_d(nbt);
        }
    }

    public static void setPlaying(ItemStack stack, boolean val) {
        WalkmanItem.setTagBool(stack, "isPlaying", val);
    }

    public static boolean isPlaying(ItemStack stack) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74762_e("isPlaying") == 1) {
                return true;
            }
        } else {
            WalkmanItem.setPlaying(stack, false);
        }
        return false;
    }

    public static void setSong(int s, ItemStack c) {
        AbstractAudioCassetteItem.setActiveSlot(s, c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean switchSong(boolean forward, ItemStack cassette) {
        if (audiocassettes.skipemptyslots) {
            int song = AbstractAudioCassetteItem.getNonEmptySlot(cassette, forward);
            if (song == -1) return false;
            WalkmanItem.setSong(song, cassette);
            return true;
        } else {
            int cur = AbstractAudioCassetteItem.getCurrentSlot(cassette);
            int max = AbstractAudioCassetteItem.getMaxSlots(cassette);
            if (forward) {
                if (cur < max) {
                    WalkmanItem.setSong(cur + 1, cassette);
                    return true;
                } else {
                    if (cur <= max) return false;
                    WalkmanItem.setSong(max, cassette);
                }
                return true;
            } else if (cur > 1) {
                WalkmanItem.setSong(cur - 1, cassette);
                return true;
            } else {
                if (cur >= 1) return false;
                WalkmanItem.setSong(1, cassette);
            }
        }
        return true;
    }

    public static ItemStack getMPInHand(EntityPlayer player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack mp = player.func_184614_ca();
        if (!(mp.func_77973_b() instanceof WalkmanItem)) {
            mp = player.func_184592_cb();
        }
        return mp.func_77973_b() instanceof WalkmanItem ? mp : ItemStack.field_190927_a;
    }

    public static ItemStack getMPbyID(EntityPlayer player, String id) {
        for (int i = 0; i < 36; ++i) {
            if (!(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof WalkmanItem) || !WalkmanItem.getID(player.field_71071_by.func_70301_a(i)).equals(id)) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    public static void playMusic(ItemStack mp, WorldServer sw, EntityPlayerMP sender) {
        List players = sw.func_73046_m().func_184103_al().func_181057_v();
        WalkmanItem.setPlaying(mp, true);
        for (EntityPlayerMP player : players) {
            if (Math.abs(player.func_180425_c().func_177958_n() - sender.func_180425_c().func_177958_n()) >= audiocassettes.WalkmanMaxSoundDistance || Math.abs(player.func_180425_c().func_177956_o() - sender.func_180425_c().func_177956_o()) >= audiocassettes.WalkmanMaxSoundDistance || Math.abs(player.func_180425_c().func_177952_p() - sender.func_180425_c().func_177952_p()) >= audiocassettes.WalkmanMaxSoundDistance) continue;
            Networking.INSTANCE.sendTo((IMessage)new SWalkmanPlayPacket(WalkmanItem.getID(mp), sender.func_110124_au().toString(), player == sender, WalkmanItem.getCassette(mp)), player);
        }
    }

    public static String getID(ItemStack mp) {
        if (mp.func_77973_b() instanceof WalkmanItem) {
            if (!mp.func_77942_o()) {
                NBTTagCompound nbt = new NBTTagCompound();
                Random rand = new Random();
                int randomNum = rand.nextInt(10000);
                nbt.func_74778_a("uid", Integer.toString(randomNum));
                mp.func_77982_d(nbt);
            }
            return mp.func_77978_p().func_74779_i("uid");
        }
        return null;
    }

    public static void stopMusic(ItemStack mp, WorldServer sw, EntityPlayerMP sender) {
        List players = sw.func_73046_m().func_184103_al().func_181057_v();
        for (EntityPlayerMP player : players) {
            Networking.INSTANCE.sendTo((IMessage)new SWalkmanStopPacket(WalkmanItem.getID(mp), player == sender), player);
        }
    }

    public static ItemStack getCassette(ItemStack mp) {
        return ((IItemHandler)mp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0);
    }
}

