/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.networking;

import com.shoxie.audiocassettes.tile.TileBoomBox;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BoomBoxNextSongPacket
implements IMessage {
    private BlockPos pos;
    private boolean manually;

    public BoomBoxNextSongPacket() {
    }

    public BoomBoxNextSongPacket(BlockPos pos, boolean manually) {
        this.pos = pos;
        this.manually = manually;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.manually = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.manually);
    }

    public static class Handler
    implements IMessageHandler<BoomBoxNextSongPacket, IMessage> {
        public IMessage onMessage(BoomBoxNextSongPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(BoomBoxNextSongPacket message, MessageContext ctx) {
            EntityPlayerMP playerMP = ctx.getServerHandler().field_147369_b;
            WorldServer sw = playerMP.func_71121_q();
            TileBoomBox tile = (TileBoomBox)sw.func_175625_s(message.pos);
            if (playerMP.func_110124_au().toString().equals(tile.owneruid) || message.manually) {
                boolean switched = tile.switchSong(true);
                if (message.manually) {
                    if (tile.isPlaying) {
                        tile.stopMusic();
                        tile.isPlaying = false;
                    }
                } else if (switched) {
                    tile.playMusic(playerMP);
                } else {
                    tile.stopMusic();
                }
            }
        }
    }
}

