/*
 * Decompiled with CFR 0.152.
 */
package com.shoxie.audiocassettes.tile;

import com.shoxie.audiocassettes.ModConfig;
import com.shoxie.audiocassettes.audiocassettes;
import com.shoxie.audiocassettes.item.AbstractAudioCassetteItem;
import com.shoxie.audiocassettes.networking.Networking;
import com.shoxie.audiocassettes.networking.SBoomBoxPlayPacket;
import com.shoxie.audiocassettes.networking.SBoomBoxStopPacket;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileBoomBox
extends TileEntity {
    public boolean isPlaying = false;
    public String id = "-";
    public String owneruid = "-";
    private ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileBoomBox.this.func_70296_d();
        }
    };

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("cassette")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("cassette"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("cassette", (NBTBase)this.itemStackHandler.serializeNBT());
        return compound;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemStackHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void sendUpdates() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
        this.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        if (!this.field_145850_b.field_72995_K) {
            return new TextComponentTranslation("block.audiocassettes.boombox", new Object[0]);
        }
        return null;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public ItemStack getCassette() {
        return this.itemStackHandler.getStackInSlot(0);
    }

    private void setSong(int song) {
        AbstractAudioCassetteItem.setActiveSlot(song, this.getCassette());
        this.sendUpdates();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean switchSong(boolean forward) {
        if (audiocassettes.skipemptyslots) {
            int song = AbstractAudioCassetteItem.getNonEmptySlot(this.getCassette(), forward);
            if (song == -1) return false;
            this.setSong(song);
        } else {
            int cur = AbstractAudioCassetteItem.getCurrentSlot(this.getCassette());
            int max = AbstractAudioCassetteItem.getMaxSlots(this.getCassette());
            if (forward) {
                if (cur < max) {
                    this.setSong(cur + 1);
                } else {
                    if (cur <= max) return false;
                    this.setSong(max);
                }
            } else if (cur > 1) {
                this.setSong(cur - 1);
            } else {
                if (cur >= 1) return false;
                this.setSong(1);
            }
        }
        this.sendUpdates();
        return true;
    }

    public void playMusic(EntityPlayerMP sender) {
        List players = this.func_145831_w().func_73046_m().func_184103_al().func_181057_v();
        this.owneruid = sender.func_110124_au().toString();
        this.isPlaying = true;
        for (EntityPlayerMP player : players) {
            if (Math.abs(player.func_180425_c().func_177958_n() - this.func_174877_v().func_177958_n()) >= ModConfig.boomboxbmaxdist || Math.abs(player.func_180425_c().func_177956_o() - this.func_174877_v().func_177956_o()) >= ModConfig.boomboxbmaxdist || Math.abs(player.func_180425_c().func_177952_p() - this.func_174877_v().func_177952_p()) >= ModConfig.boomboxbmaxdist) continue;
            boolean isowner = player == sender;
            Networking.INSTANCE.sendTo((IMessage)new SBoomBoxPlayPacket(this.func_174877_v(), this.getID(), isowner, this.getCassette()), player);
        }
    }

    public void stopMusic() {
        List players = this.func_145831_w().func_73046_m().func_184103_al().func_181057_v();
        for (EntityPlayerMP player : players) {
            Networking.INSTANCE.sendTo((IMessage)new SBoomBoxStopPacket(this.func_174877_v(), this.getID()), player);
        }
    }

    public String getID() {
        if (this.id.equals("-")) {
            Random rand = new Random();
            int randomNum = rand.nextInt(10000);
            this.id = Integer.toString(randomNum);
        }
        return this.id;
    }
}

